/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports.generator.highchart;

import com.excentis.products.byteblower.report.data.entities.widgets.ReportItemWidgetEntity;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.jasper.GenerateReport;
import com.excentis.products.byteblower.report.generator.jasper.datasource.ByteBlowerReportDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.CombinedDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.highcharts.FbLatencyRotHighchartsDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.highcharts.FbOosRotHighchartsDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.highcharts.FbThroughputRotHighchartsDataSource;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.ResultsOverTimeChartBean;
import com.excentis.products.byteblower.report.generator.jasper.subreports.entities.ResultsOverTimeChartEntity;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeCharts;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.testdata.data.FlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatency;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatencySnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.FbOutOfSequence;
import com.excentis.products.byteblower.results.testdata.data.entities.FbOutOfSequenceSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.FbSource;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTrigger;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTriggerSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbLatencyReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbOutOfSequenceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbTriggerReader;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class GenerateFbCombinedResultsOverTimeHighcharts
extends GenerateResultsOverTimeCharts<FbFlowInstance> {
    public GenerateFbCombinedResultsOverTimeHighcharts(GenerateReport<GenerateReportListener> parentAction, ReportItemWidgetEntity widget, ReportGeneration reportGeneration, Class<FbFlowInstance> flowType) {
        super(parentAction, widget, reportGeneration, flowType);
    }

    @Override
    protected ResultsOverTimeChartEntity createChartEntity(ResultsOverTimeChartBean<?> bean) {
        return new ResultsOverTimeChartEntity("results_over_time_latency_highcharts", bean);
    }

    @Override
    protected void fillBeans() {
        Scenario scenario = this.getScenario();
        FlowInstanceManager manager = this.getFlowInstanceManager();
        List flowInstances = manager.getAllFlowsOfType(scenario, this.flowType);
        for (FbFlowInstance flowInstance : flowInstances) {
            FbFlowInstanceReader reader = EntityReaderFactory.create((FbFlowInstance)flowInstance);
            String flowName = reader.getName();
            FbSource source = flowInstance.getSource();
            Set destinations = reader.getDestinationsAndEavesdroppers();
            for (FbDestination destination : destinations) {
                ArrayList<ByteBlowerReportDataSource> sources = this.createPagingQueriesNew(source, destination, flowName);
                TestDataReference testDataReference = this.getTestDataReference();
                CombinedDataSource data = new CombinedDataSource(sources);
                if (((ByteBlowerReportDataSource)data).isEmpty()) continue;
                this.beans.add(new ResultsOverTimeChartBean(testDataReference, destination.getPort(), (ByteBlowerReportDataSource)data));
            }
        }
    }

    protected ArrayList<ByteBlowerReportDataSource> createPagingQueriesNew(FbSource source, FbDestination destination, String flowName) {
        FbOutOfSequence fbOos;
        FbTrigger fbTrigger;
        EntityManager entityManager = this.getEntityManager();
        ArrayList<ByteBlowerReportDataSource> destinationChartDataSources = new ArrayList<ByteBlowerReportDataSource>();
        String sourceName = source.getPort().getName();
        String destinationName = destination.getPort().getName();
        FbLatency fbLatency = destination.getLatency();
        if (fbLatency != null) {
            FbLatencyReader fbLatencyReader = EntityReaderFactory.create((FbLatency)fbLatency);
            TypedQuery snapshotQuery = fbLatencyReader.getSnapshotsQuery(entityManager);
            destinationChartDataSources.add(new FbLatencyRotHighchartsDataSource(entityManager, this, flowName, sourceName, destinationName, (TypedQuery<FbLatencySnapshot>)snapshotQuery));
        }
        if ((fbTrigger = destination.getTrigger()) != null) {
            FbTriggerReader fbTriggerReader = EntityReaderFactory.create((FbTrigger)fbTrigger);
            TypedQuery snapshotQuery = fbTriggerReader.getSnapshotsQuery(entityManager);
            destinationChartDataSources.add(new FbThroughputRotHighchartsDataSource(entityManager, this, flowName, sourceName, destinationName, (TypedQuery<FbTriggerSnapshot>)snapshotQuery));
        }
        if ((fbOos = destination.getOutOfSequence()) != null) {
            FbOutOfSequenceReader fbOosReader = EntityReaderFactory.create((FbOutOfSequence)fbOos);
            TypedQuery snapshotQuery = fbOosReader.getSnapshotsQuery(entityManager);
            destinationChartDataSources.add(new FbOosRotHighchartsDataSource(entityManager, this, flowName, sourceName, destinationName, (TypedQuery<FbOutOfSequenceSnapshot>)snapshotQuery));
        }
        return destinationChartDataSources;
    }

    @Override
    protected ByteBlowerReportDataSource createPagingQuery(FbFlowInstance flowInstance) {
        ArrayList<ByteBlowerReportDataSource> queries = this.createPagingQueries(flowInstance);
        return (ByteBlowerReportDataSource)queries.get(0);
    }
}

