/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports.generator.highchart;

import com.excentis.products.byteblower.report.data.entities.widgets.ReportItemWidgetEntity;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.jasper.GenerateReport;
import com.excentis.products.byteblower.report.generator.jasper.datasource.ByteBlowerReportDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.RssiDataSource;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.ResultsOverTimeChartBean;
import com.excentis.products.byteblower.report.generator.jasper.subreports.entities.ResultsOverTimeChartEntity;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeCharts;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbSource;
import com.excentis.products.byteblower.results.testdata.data.entities.WiFiSample;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.HashSet;

public class GenerateRssiOverTimeHighcharts
extends GenerateResultsOverTimeCharts<FbFlowInstance> {
    public GenerateRssiOverTimeHighcharts(GenerateReport<GenerateReportListener> parentAction, ReportItemWidgetEntity widget, ReportGeneration reportGeneration, Class<FbFlowInstance> flowType) {
        super(parentAction, widget, reportGeneration, flowType);
    }

    @Override
    protected ResultsOverTimeChartEntity createChartEntity(ResultsOverTimeChartBean<?> bean) {
        return new ResultsOverTimeChartEntity("results_over_time_rssi_highcharts", bean);
    }

    @Override
    protected void fillBeans() {
        String pattern = "_ABC_";
        HashSet<String> interest = new HashSet<String>();
        for (WiFiSample gg : WiFiSample.getSamples((TestDataPersistenceController)this.getPersistenceController())) {
            interest.add(String.valueOf(gg.getPortname()) + pattern + gg.getNetinterface());
        }
        for (String networkInterface : interest) {
            TestDataReference testDataReference = this.getTestDataReference();
            String[] res = networkInterface.split(pattern);
            String portname = res[0];
            String netName = res[1];
            String query = "SELECT t FROM WiFiSample t WHERE t.portname = :portname AND t.netinterface = :netinterface ORDER BY t.timestamp ASC";
            TypedQuery sample = this.getEntityManager().createQuery(query, WiFiSample.class);
            sample.setParameter("portname", (Object)portname);
            sample.setParameter("netinterface", (Object)netName);
            RssiDataSource data = new RssiDataSource(this.getEntityManager(), this, portname, netName, (TypedQuery<WiFiSample>)sample);
            if (((ByteBlowerReportDataSource)data).isEmpty()) continue;
            this.beans.add(new ResultsOverTimeChartBean(testDataReference, null, (ByteBlowerReportDataSource)data));
        }
    }

    protected ArrayList<ByteBlowerReportDataSource> createPagingQueriesNew(FbSource source, FbDestination destination, String flowName) {
        throw new RuntimeException("Not implemented, why do you need this?");
    }

    @Override
    protected ByteBlowerReportDataSource createPagingQuery(FbFlowInstance flowInstance) {
        throw new RuntimeException("Not implemented, why do you need this?");
    }
}

