/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.jasper.subreports.generator.highchart;

import com.excentis.products.byteblower.report.data.entities.widgets.ReportItemWidgetEntity;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.jasper.GenerateReport;
import com.excentis.products.byteblower.report.generator.jasper.datasource.ByteBlowerReportDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.CombinedDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.highcharts.HttpThroughputRotHighchartsDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.highcharts.TcpReceiveWindowRotHighchartDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.highcharts.TcpRetransmissionWindowRotHighchartDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.highcharts.TcpRoundTripTimeRotHighchartDataSource;
import com.excentis.products.byteblower.report.generator.jasper.datasource.highcharts.TcpThroughputRotHighchartDataSource;
import com.excentis.products.byteblower.report.generator.jasper.subreports.beans.ResultsOverTimeChartBean;
import com.excentis.products.byteblower.report.generator.jasper.subreports.entities.ResultsOverTimeChartEntity;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeCharts;
import com.excentis.products.byteblower.report.generator.jasper.subreports.generator.GenerateResultsOverTimeSubReports;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.testdata.data.FlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpSessionReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.TcpSessionReader;
import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.List;

public class GenerateTcpThroughputResultsOverTimeHighcharts
extends GenerateResultsOverTimeCharts<HttpFlowInstance> {
    public GenerateTcpThroughputResultsOverTimeHighcharts(GenerateReport<GenerateReportListener> parentAction, ReportItemWidgetEntity widget, ReportGeneration reportGeneration, Class<HttpFlowInstance> flowType) {
        super(parentAction, widget, reportGeneration, flowType);
    }

    @Override
    protected ResultsOverTimeChartEntity createChartEntity(ResultsOverTimeChartBean<?> bean) {
        return new ResultsOverTimeChartEntity("results_over_time_highcharts", bean);
    }

    @Override
    protected boolean hasMultipleChartsPerFlow() {
        return true;
    }

    @Override
    protected void fillBeans() {
        Scenario scenario = this.getScenario();
        FlowInstanceManager manager = this.getFlowInstanceManager();
        List flowInstances = manager.getAllFlowsOfType(scenario, this.flowType);
        for (HttpFlowInstance flowInstance : flowInstances) {
            ArrayList<ByteBlowerReportDataSource> sources = this.createPagingQueries(flowInstance);
            TestDataReference testDataReference = this.getTestDataReference();
            CombinedDataSource data = new CombinedDataSource(sources);
            if (((ByteBlowerReportDataSource)data).isEmpty()) continue;
            this.beans.add(new ResultsOverTimeChartBean(testDataReference, (FlowInstance)flowInstance, (ByteBlowerReportDataSource)data));
        }
    }

    @Override
    protected ArrayList<ByteBlowerReportDataSource> createPagingQueries(HttpFlowInstance flowInstance) {
        ArrayList<ByteBlowerReportDataSource> result = new ArrayList<ByteBlowerReportDataSource>();
        if (flowInstance == null) {
            return result;
        }
        HttpFlowInstanceReader httpReader = EntityReaderFactory.create((HttpFlowInstance)flowInstance);
        if (httpReader == null || !httpReader.isValid(flowInstance)) {
            return result;
        }
        HttpSessionReader httpSourceSessionReader = httpReader.getSourceHttpSessionReader();
        HttpSessionReader httpDestinationSessionReader = httpReader.getDestinationHttpSessionReader();
        TcpSession tcpSourceSession = httpReader.getSourceHttpSession().getTcpSession();
        TcpSessionReader tcpSourceSessionReader = EntityReaderFactory.create((TcpSession)tcpSourceSession);
        TcpSession tcpDestinationSession = httpReader.getDestinationHttpSession().getTcpSession();
        TcpSessionReader tcpSessionDestinationReader = EntityReaderFactory.create((TcpSession)tcpDestinationSession);
        String flowName = httpReader.getName();
        EntityManager entityManager = this.getEntityManager();
        Long sourceTxDurationNs = httpSourceSessionReader.getTxDurationNanoseconds();
        Long destinationTxDurationNS = httpDestinationSessionReader.getTxDurationNanoseconds();
        if (sourceTxDurationNs != null || destinationTxDurationNS != null) {
            Long rxDurationNs = httpDestinationSessionReader.getRxDurationNanoseconds();
            result.add(TcpReceiveWindowRotHighchartDataSource.receiveWindow(entityManager, this, flowName, "U", tcpSourceSessionReader));
            result.add(TcpRetransmissionWindowRotHighchartDataSource.retransmissions(entityManager, this, flowName, "Z", tcpSourceSessionReader));
            result.add(TcpRoundTripTimeRotHighchartDataSource.avgRoundTripTime(entityManager, this, flowName, tcpSourceSessionReader));
            result.add(TcpRoundTripTimeRotHighchartDataSource.maxRoundTripTime(entityManager, this, flowName, tcpSourceSessionReader));
            result.add(TcpRoundTripTimeRotHighchartDataSource.minRoundTripTime(entityManager, this, flowName, tcpSourceSessionReader));
            if (rxDurationNs == null) {
                result.add(TcpThroughputRotHighchartDataSource.txThroughput(entityManager, this, flowName, "W", tcpSourceSessionReader));
                result.add(HttpThroughputRotHighchartsDataSource.txGoodput(entityManager, (GenerateResultsOverTimeSubReports<HttpFlowInstance>)this, flowName, "Y", httpSourceSessionReader));
            } else {
                result.add(TcpThroughputRotHighchartDataSource.rxDataSource(entityManager, (GenerateResultsOverTimeSubReports<HttpFlowInstance>)this, flowName, "V", tcpSessionDestinationReader));
                result.add(HttpThroughputRotHighchartsDataSource.rxGoodput(entityManager, (GenerateResultsOverTimeSubReports<HttpFlowInstance>)this, flowName, "X", httpDestinationSessionReader));
            }
        }
        return result;
    }

    @Override
    protected ByteBlowerReportDataSource createPagingQuery(HttpFlowInstance flowInstance) {
        ArrayList<ByteBlowerReportDataSource> queries = this.createPagingQueries(flowInstance);
        return (ByteBlowerReportDataSource)queries.get(0);
    }

    @Override
    public boolean needsTimeZoneOffset() {
        return false;
    }
}

