define('guruaggrxtcp', ["require", 'bb_highcharts'], function(require) {
	var Highcharts = require('bb_highcharts');
	var result = function(instanceData) {
//		console.log(instanceData);
		var series = instanceData.series[0]
		var flowName = series[0].D
		var yAxisTitle = series[0].E + " " + series[0].F
		var flowNames = []
		var serieData = []
		
		function strMinDigits(val, minSize){
			let strVal = "" + val;
			let repeatCnt = minSize - strVal.length
			let header = ""
			while(repeatCnt > 0) {
				repeatCnt--;
				header = header + "0";
			}
			return header + strVal;
		}

//		function getFlowName(sample){
//		return sample.A;
//		}

		var actualSeries = []
		// TODO much of this could rendered in the Java code rather than in the Browser.

		let uniqueNames = new Set();
		for(let i=0 ; i<series.length ; i++) {
			let name = series[i].A 
			uniqueNames.add(name)
		}
//		series.map(getFlowName).forEach(function(x){uniqueNames.add(x)});
		// -> DONT DO THIS, not supported by eclipse browser integrated in the GUI...

		// Highcharts can't really handle series where snapshots don't align.
		// Merging them manually to avoid triggering this bug. 
		// TODO This can be done in less steps. Sorting + looping over it is sufficient.
//		let uniqueTimes = new Set();

//		let allTimes = Array.from(new Set(series.map(function(x){return x.B}))).sort(function (a,b){return a- b;});
		// -> DONT DO THIS, not supported by eclipse browser integrated in the GUI...

		// use a set to make sure that all duplicate times are ignored :
		let uniqueTimes = new Set();
		for(let i=0 ; i<series.length ; i++) {
			let time = series[i].B 
			uniqueTimes.add(time)
		}
		// then, make an array, to be able to sort the times :
		var sortedTimes = []
		function pushIt(value) {
			sortedTimes.push(value)
		}
		uniqueTimes.forEach(pushIt);        
		sortedTimes.sort(function (a, b) {
			return a-b;
		});

		//TODO This could be rendered in a single pass..
		uniqueNames.forEach(function(fn) { 
			let selectedData = series.filter(function(serie) {
				return serie.A == fn;
			}).map(function(filtered) {
				return [filtered.B, filtered.C]
			})
			selectedData.sort(function(a,b){return a[0] - b[0];});
			let mergedData = [];
			let thisSeriesCtr = 0;
			let seriesVal = 0;
			for(let allTimestamps = 0; allTimestamps < sortedTimes.length; allTimestamps++){
				let currentTime = sortedTimes[allTimestamps];
				if(thisSeriesCtr >= selectedData.length) {
					mergedData.push([currentTime, 0]);
				} else if(currentTime < selectedData[thisSeriesCtr][0]){
					mergedData.push([currentTime, seriesVal]);
				} else if (currentTime === selectedData[thisSeriesCtr][0]){
					seriesVal = selectedData[thisSeriesCtr][1];
					thisSeriesCtr++;
					mergedData.push([currentTime, seriesVal]);
				} else{
					// Ignore for now, reason is either rounding errors or duplicate snapshots..
					// TODO fix/handle those reasons
				}
			}
			actualSeries.push({
				name: fn,
				data: mergedData
			})
		})

		Highcharts.chart(instanceData.id, {
			title: false,
			subtitle: false,
			chart: {
				zoomType: 'x',
				panning: true,
				panKey: 'shift',
				type: 'area'
			},
			tooltip: {
				formatter: function () {
					var flowTooltips = '<b>' + this.x + '</b><br>';
					var sum = 0;
					this.points.forEach(function(point) {
						flowTooltips += '<span style="color:' + point.series.color + '">\u25CF</span><b>' + point.series.name + ':</b> ' + point.y + ' <br>'
						sum += point.y
					})
					flowTooltips += '<b>Total:</b> ' + sum
					return flowTooltips;
				},
				shared: true,
				pointFormat: '<b>{series.name}:</b> {point.y:.2f} ( {point.percentage:.0f}% )<br>',
			},
			xAxis: {
				labels: {
					formatter: function () {
						milliseconds = this.value % 1000
						if(milliseconds == 0) {
							let seconds_part = (this.value - milliseconds) % (1000 * 60)
							let seconds = seconds_part /1000
							
							let minutes_part = (this.value - (seconds_part + milliseconds)) % (1000 * 60 *60)
							let minutes = minutes_part / (60 * 1000)
							
							let hours_part = (this.value - (minutes_part + seconds_part + milliseconds))
							let hours = hours_part / (3600 * 1000)
							
							return strMinDigits(hours,2) + ":" + 
							       strMinDigits(minutes,2) + ":" +
							       strMinDigits(seconds,2) 
						} 
					}
				},
				min: 0,
				title: {
					text: '<span style="font-family: \'DejaVu Sans\', Arial, Helvetica, sans-serif; color: #F7941C; font-size: 12px; line-height: 1.4640625; font-weight: bold;">Time [h:min:s]</span><br>'
				},
			},
			yAxis: { 

				title: {
					text: '<span style="font-family: \'DejaVu Sans\', Arial, Helvetica, sans-serif; color: #00AEEF; font-size: 20px; line-height: 1.2640625; ">' + flowName + '</span><br>\
					<span style="font-family: \'DejaVu Sans\', Arial, Helvetica, sans-serif; color: #00AEEF; font-size: 12px; line-height: 1.2640625; font-weight: bold; ">' + yAxisTitle + '</span>'
				}
			},
			plotOptions: {
				area: {
					stacking: 'normal',
					marker: {
						enabled: false,
						symbol: 'circle',
						radius: 2,
						states: {
							hover: {
								enabled: true
							}
						}
					}
				}
			},
			series:actualSeries
		})
	}
	return result;
});