define('gurudist', ["require", 'bb_highcharts'], function(require) {
    var Highcharts = require('bb_highcharts');
    function add_with_sufficient_rounding(a,b, start_rounding) {
        let result = a + b
        let rounded = result.toFixed(start_rounding);
        let MAX_ROUNDING = 20
        while (start_rounding < MAX_ROUNDING) {
            if (a != rounded && b != rounded) {
                return rounded;
            }
            start_rounding += 1
            rounded = result.toFixed(start_rounding);
        }
        return result;
    }
    var result = function(instanceData) {
        var combinedSeries = instanceData.series[0]
        
        var histogram_bins = [];
        var yValues = [];
        var flowDestination = combinedSeries[0].C + " : " + combinedSeries[0].E;
        var drr = instanceData.parameter_data_rate_unit;
        var heights = [];
        
        combinedSeries.forEach(function(element) {
//            A - x_value
//            B - y_value
//            C - flow_name
//            D - height
//            E - destination_name
//            F - tick_label

            let value_x_value = element.A,
            value_y_value = element.B,
            value_height = element.D,
            value_tick_label = element.F

            if(value_x_value != null) {
                if(value_y_value != null) {
                    histogram_bins.push([value_x_value, value_y_value])
                }
            }
        });
        let bin_width = histogram_bins[1][0] - histogram_bins[0][0]
        console.log(bin_width)

        let excentisorange = '#F7941C'
        let excentisgreen = '#00A650'
        let excentisblue = '#00AEEF'

        Highcharts.chart(instanceData.id, {
            title: {
                text: '<span style="font-family: \'DejaVu Sans\', Arial, Helvetica, sans-serif; color: #00AEEF; font-size: 20px; line-height: 1.2640625; ">' + flowDestination + '</span>'
            },
            subtitle: false,
            chart: {
                zoomType: 'x',
                panning: true,
                panKey: 'shift',
                type: 'column'
            },
            tooltip: {
                useHTML: true,
                headerFormat: null,
                pointFormatter: function() {
                    let y_value =  this.y
                    let latency_bin = this.category.toFixed(3)
                    let next_bin = add_with_sufficient_rounding(this.category, bin_width,3)
                    let pck_count = y_value.toFixed(0)
                    let tooltiptext =
                                '<table><tr><td>Latency:</td><td><b>' + latency_bin + ' - ' + next_bin + ' ' + instanceData.parameter_time_unit +' </b></td>' +
                                '<tr><td style="color:' + this.series.color + '"> '+ this.series.name + ':</td><td><b> ' + pck_count + '</b> frames</td></tr>' +
                                '</table>'
                    return tooltiptext
                },
                valueDecimals: 2
            },
            xAxis: [
                {
                    title: {
                        text: '<span style="font-family: \'DejaVu Sans\', Arial, Helvetica, sans-serif; color: #F7941C; font-size: 12px; line-height: 1.4640625; font-weight: bold;">Latency [' + instanceData.parameter_time_unit + ']</span><br>'
                    },
                }
            ],
            yAxis: {
                title: {
                    text: '<span style="font-family: \'DejaVu Sans\', Arial, Helvetica, sans-serif; color: #00AEEF; font-size: 12px; line-height: 1.2640625; font-weight: bold; ">Number Of Frames</span>'
                },
                labels: {
                    overflow: 'justify'
                }
            },
            series: [
                 {
                     name: flowDestination,
                     data: histogram_bins,
                     color: excentisblue,
                     showInLegend: false
                 }
             ]
        })
    }
    return result;
});
