

function OosChart(instanceData) {
    this.combinedSeries = instanceData.series[0]
    this.flow_type = instanceData.flow_type;
	this.parameter_data_rate_unit = instanceData.parameter_data_rate_unit
	this.parameter_rtt_unit = instanceData.parameter_time_unit
	this.flow_name = this.combinedSeries[0].A;
    

    this.separateSeries = function() {
		var series = {
            serieNames: [],
			throughput : [],
			tooltips: new Map()
		}
		this.combinedSeries.forEach(function(element){
			var C = element.C,
			D = element.D,
            E = element.E,
            B = element.B
            series.serieNames.push(B);
            series.tooltips.set([C, E])
            series.throughput.push([C, D])
			
		});
		return series;
	}
}

excentisblue = '#00AEEF',
excentisorange = '#F7941C',
excentisgreen = '#00A650',
excentisgrey = '#8a8a8a',
excentishardblue = '#0000C8'

define('guruoos', ['require', 'bb_highcharts'], function(require) {

	var Highcharts = require('bb_highcharts')
    var result = function(instanceData) {
        var chart = new OosChart(instanceData);
        var series = chart.separateSeries();
		Highcharts.chart(instanceData.id, { //instancedata.id is the DIV TAG id => there the chart will be generated

			title: false,
			subtitle: false,
			chart: {
				zoomType: 'x',
				panning: true,
				panKey: 'shift',
				//panning: true
			},
			xAxis: {
				labels: {
					formatter: function () {
						//return Highcharts.dateFormat('%H:%M:%S.%L', this.value);
						return Highcharts.dateFormat('%H:%M:%S', this.value);
					}
				},
				title: {
					text: '<span style="font-family: \'DejaVu Sans\', Arial, Helvetica, sans-serif; color: #F7941C; font-size: 12px; line-height: 1.4640625; font-weight: bold;">Time</span>'
				}

			},
			yAxis: [
				{
					title: {
						text: '<span style="font-family: \'DejaVu Sans\', Arial, Helvetica, sans-serif; color: #00AEEF; font-size: 20px; line-height: 1.2640625; ">' + chart.flow_name + '</span><br>\
						<span style="font-family: \'DejaVu Sans\', Arial, Helvetica, sans-serif; color: #00AEEF; font-size: 12px; line-height: 1.2640625; ">Bitrate [' + chart.parameter_data_rate_unit + ']</span>'
					},
				},
				{
					title: {
						text: '<span style="font-family: \'DejaVu Sans\', Arial, Helvetica, sans-serif; color: #8a8a8a; font-size: 12px; line-height: 1.2640625; font-weight: bold; ">Out of Sequence</span><br>'
					},					
					opposite: true,
				}				
			],
			plotOptions: {
				series: {
					events: {
                        hide: function (event) {
                            var serieYAxis = this.yAxis;
                            serieYAxis.visivel = false;
                            serieYAxis.update({
                                title: {
                                    style: {"display":"none"}
                                }
                            });


                            resizeAxis(axis);

                        },
                        show: function (event) {
                            this.yAxis.visivel = true;
                            this.yAxis.update({
                                title: {
                                    style: {"display":"initial"}
                                }
                            });



                            resizeAxis(axis);
                        }
                    }
				}
			},
			tooltip: {
				//enabled: true,
				//crosshairs: true,
				//shared: true, // conflicts with the formatter function
				//formatter
				formatter: function () {
					
					tooltipText = ""
					try {
						tooltipText = series.tooltips.get(this.x)
						
					} catch (e) { // --- if no tooltip is available catch and ignore the exception here
//													console.log(e instanceof TypeError); // true
//													console.log(e.message);              // "Hello"
						tooltipText = "none";
					}
					return tooltipText +  this.y

				},
				followTouchMove: false
			},
			legend: {
				borderColor: excentisblue,//'#121212',
				borderWidth: 1
			},
			series: [
				{
					yAxis: 0,
					name: series.serieNames[0],
					data: series.throughput,
					zIndex: 4,
					color: excentisblue,
	
				}
			]
        });
	}
	return result
})