/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.results.dataprovider.plugin.Activator;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import org.apache.commons.lang3.text.WordUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class BasicPrinter
implements AutoCloseable {
    private static final String OFFSET_FRON_MARGIN = "    ";
    protected int lastColumnEstimate = 0;

    protected String getCaller() {
        String caller = "";
        int depth = 3;
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        if (trace.length > depth) {
            StackTraceElement before = trace[depth];
            caller = String.format("%s in %s at %d", before.getMethodName(), before.getClassName(), before.getLineNumber());
        }
        return caller;
    }

    public abstract void title(String var1) throws IOException;

    public abstract void println() throws IOException;

    public abstract void printRecord(Object ... var1) throws IOException;

    public abstract HeaderPrinter headerPrinter();

    public abstract void printComment(String var1) throws IOException;

    public class HeaderPrinter {
        private ArrayList<ColumnDocumentation> headers = new ArrayList();

        public HeaderPrinter() {
            BasicPrinter.this.lastColumnEstimate = 0;
        }

        public void add(String columnName, String documentation) {
            this.headers.add(new ColumnDocumentation(columnName, documentation));
            ++BasicPrinter.this.lastColumnEstimate;
        }

        public void add(String columnName, String unit, String documentation) {
            this.headers.add(new ColumnDocumentation(columnName, unit, documentation));
            ++BasicPrinter.this.lastColumnEstimate;
        }

        private void checkCapitalConvention(ColumnDocumentation header) {
            boolean startsCapital;
            char firstLetter = header.columnName.charAt(0);
            boolean bl = startsCapital = 'A' <= firstLetter && firstLetter <= 'Z';
            if (!startsCapital) {
                String message = String.format("CSV report:: Against convention header %s isn't capital.%nDescription: %s%n%n", header.columnName, header.documentation);
                Status st = new Status(2, "com.excentis.products.byteblower.results.dataprovider.plugin", message);
                Activator.getDefault().getLog().log((IStatus)st);
            }
        }

        private String humanReadableHeader(ColumnDocumentation header) {
            String result = header.columnName;
            if (header.hasUnit()) {
                result = String.valueOf(result) + '[' + header.unit + ']';
            }
            return result;
        }

        void printHeaders() throws IOException {
            BasicPrinter.this.lastColumnEstimate = this.headers.size();
            StringWriter writer = new StringWriter();
            String seperator = "";
            for (ColumnDocumentation header : this.headers) {
                this.checkCapitalConvention(header);
                writer.append(seperator);
                writer.append(this.humanReadableHeader(header));
                seperator = ", ";
            }
            BasicPrinter.this.printComment(writer.toString());
        }

        void printDocumentation() throws IOException {
            int ctr = 0;
            while (ctr < this.headers.size()) {
                ColumnDocumentation header = this.headers.get(ctr);
                String title = header.columnName;
                StringBuilder docString = new StringBuilder();
                docString.append(header.documentation);
                if (header.hasUnit()) {
                    docString.append(" Measured in ");
                    docString.append(header.unit);
                    docString.append(".");
                }
                String documentation = WordUtils.wrap((String)docString.toString(), (int)70);
                BasicPrinter.this.printComment(String.valueOf(title) + ": ");
                String[] stringArray = documentation.split("\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String docline = stringArray[n2];
                    BasicPrinter.this.printComment(BasicPrinter.OFFSET_FRON_MARGIN + docline);
                    ++n2;
                }
                ++ctr;
            }
        }

        private class ColumnDocumentation {
            final String columnName;
            final String documentation;
            final String unit;

            ColumnDocumentation(String columnName, String documentation) {
                this.columnName = columnName;
                this.unit = "";
                this.documentation = documentation;
            }

            public ColumnDocumentation(String columnName, String unit, String documentation) {
                this.columnName = columnName;
                this.unit = unit;
                this.documentation = documentation;
            }

            public boolean hasUnit() {
                return !this.unit.isEmpty();
            }
        }
    }
}

