/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.plaintext.BasicPrinter;
import com.excentis.products.byteblower.report.generator.plaintext.CSVItem;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.testdata.data.EventManager;
import com.excentis.products.byteblower.results.testdata.data.entities.Event;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

class EventTable
implements CSVItem {
    private final Set<EventSeverity> severity;
    private final String title;

    EventTable(String title, EventSeverity ... filter) {
        this.severity = new HashSet<EventSeverity>(Arrays.asList(filter));
        this.title = title;
    }

    @Override
    public void write(ReportData data, BasicPrinter printer) throws IOException {
        EventManager ev = new EventManager(data.testDataController());
        ArrayList<String> descriptions = new ArrayList<String>();
        for (Event event : ev.getEntities()) {
            if (!this.severity.contains(event.getSeverity())) continue;
            descriptions.add(event.getDescription());
        }
        if (descriptions.isEmpty()) {
            return;
        }
        printer.title(this.title);
        for (String line : descriptions) {
            printer.printComment(line);
        }
        printer.println();
    }
}

