/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.core.parameters.ParameterConvertor;
import com.excentis.products.byteblower.report.generator.core.parameters.ThroughputTypeParameter;
import com.excentis.products.byteblower.report.generator.plaintext.BasicPrinter;
import com.excentis.products.byteblower.report.generator.plaintext.CSVItem;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.testdata.data.FlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowTemplateReader;
import com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit;
import com.excentis.products.byteblower.results.testdata.data.utils.EthernetThroughputType;
import java.io.IOException;
import java.util.List;

class FrameBlastingInfoTable
implements CSVItem {
    FrameBlastingInfoTable() {
    }

    @Override
    public void write(ReportData data, BasicPrinter printer) throws IOException {
        Scenario scenario;
        FlowInstanceManager manager = new FlowInstanceManager(data.testDataController());
        List fbFlows = manager.getAllFrameBlasting(scenario = data.scenario());
        if (fbFlows.isEmpty()) {
            return;
        }
        printer.title("Frameblasting configuration info");
        BasicPrinter.HeaderPrinter header = printer.headerPrinter();
        header.add("Flow name", "The name of the flow.");
        header.add("Flow template", "The name of the configured flow template.");
        header.add("Start delay", "ns", "The configured start-delay of the flow.");
        header.add("Interframe gap", "ns", "The gap between subsequent frames.");
        header.add("Frame size", "bytes", "The size of the frames in the frametemplate. The value is either amount of bytes in the frame(all frames same size), or the string 'mixed'.");
        header.add("Throughput", "bit/s", "The configured throughtput.");
        header.add("TOS", "The value of the tos byte.");
        header.printDocumentation();
        header.printHeaders();
        for (FbFlowInstance flowInstance : fbFlows) {
            FbFlowInstanceReader flowReader = EntityReaderFactory.create((FbFlowInstance)flowInstance);
            FbFlowTemplateReader templateReader = flowReader.getFlowTemplateReader();
            String flowName = flowReader.getName();
            String flowTemplate = templateReader.getName();
            Long start = flowInstance.getStartTime();
            Long frameGap = templateReader.getFrameInterval();
            String frameSizeInfo = templateReader.getFrameSizeInfo();
            EthernetThroughputType etherType = ParameterConvertor.convertThroughputType((ThroughputTypeParameter)data.getThroughputType());
            Double throughput = templateReader.getThroughput(etherType, DataRateUnit.BIT_PER_SECOND);
            String tos = flowReader.getTos();
            printer.printRecord(flowName, flowTemplate, start, frameGap, frameSizeInfo, throughput, tos);
        }
        printer.println();
    }
}

