/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.plaintext.BasicPrinter;
import com.excentis.products.byteblower.report.generator.plaintext.CSVItem;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatency;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatencySnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbLatencyReader;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.io.IOException;
import java.util.List;
import java.util.Set;

class FrameBlastingLatencyResultsOverTime
implements CSVItem {
    FrameBlastingLatencyResultsOverTime() {
    }

    @Override
    public void write(ReportData data, BasicPrinter printer) throws IOException {
        List<FbFlowInstance> fbFlows = data.fbFlows();
        boolean needsDocumentation = true;
        for (FbFlowInstance flowInstance : fbFlows) {
            FbFlowInstanceReader reader = EntityReaderFactory.create((FbFlowInstance)flowInstance);
            String flowName = reader.getName();
            Set destinations = reader.getDestinationsAndEavesdroppers();
            BasicPrinter.HeaderPrinter header = printer.headerPrinter();
            header.add("Flow", "The name of the flow.");
            header.add("BB port", "The name of the ByteBlower port.");
            header.add("Time", "ns", "Timestamp of the snapshot. This timestamp is the start of the snapshot. It is based on the unix time at the ByteBlower server.");
            header.add("Duration", "ns", "Duration of the snapshot.");
            header.add("PacketCount", "The number of valid packets received within during the snapshot. A packet is valid when its timestamp is in the expected range.");
            header.add("InvalidPacketCount", "The number of packets with a timestamp far out of the expected value. These packets were ignored for the latency calculations.");
            header.add("Average", "ns", "The average delay of a packet within the snapshot.");
            header.add("Maximum", "ns", "The maximum measured delay within the snapshot.");
            header.add("Minimum", "ns", "The minimum measured delay within the snapshot.");
            header.add("Jitter", "ns", "Jitter of the packets. This measured as as the standard deviation of the latency of the packets.");
            for (FbDestination destination : destinations) {
                String portName = destination.getPort().getName();
                if (destination.getLatency() == null) continue;
                FbLatencyReader fbLatency = EntityReaderFactory.create((FbLatency)destination.getLatency());
                EntityManager entityManager = data.entityManager();
                TypedQuery snapshotQuery = fbLatency.getSnapshotsQuery(entityManager);
                snapshotQuery.setHint("jakarta.persistence.cache.storeMode", (Object)CacheStoreMode.BYPASS);
                snapshotQuery.setHint("eclipselink.maintain-cache", (Object)"False");
                List list = snapshotQuery.getResultList();
                boolean first = true;
                for (FbLatencySnapshot snapshot : list) {
                    if (needsDocumentation) {
                        printer.title("Frameblasting latency results over time");
                        header.printDocumentation();
                        needsDocumentation = false;
                    }
                    if (first) {
                        first = false;
                        printer.printComment("Flow name: " + flowName);
                        printer.printComment("Port name: " + portName);
                        header.printHeaders();
                    }
                    long time = snapshot.getSnapshotTime();
                    long duration = snapshot.getSnapshotDuration();
                    long average = snapshot.getLatencyAverage();
                    long maximum = snapshot.getLatencyMaximum();
                    long minimum = snapshot.getLatencyMinimum();
                    long packetCount = snapshot.getPacketCountValid();
                    long packetInvalid = snapshot.getPacketCountInvalid();
                    long jitter = snapshot.getJitter();
                    printer.printRecord(flowName, portName, time, duration, packetCount, packetInvalid, average, maximum, minimum, jitter);
                }
                entityManager.close();
                printer.println();
            }
        }
    }
}

