/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.plaintext.BasicPrinter;
import com.excentis.products.byteblower.report.generator.plaintext.CSVItem;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbOutOfSequence;
import com.excentis.products.byteblower.results.testdata.data.entities.FbOutOfSequenceSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbOutOfSequenceReader;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.io.IOException;
import java.util.List;
import java.util.Set;

class FrameBlastingOOResultsOverTime
implements CSVItem {
    FrameBlastingOOResultsOverTime() {
    }

    @Override
    public void write(ReportData data, BasicPrinter printer) throws IOException {
        BasicPrinter.HeaderPrinter header = printer.headerPrinter();
        header.add("Flow", "The name of the flow");
        header.add("Port", "The name of the ByteBlower port.");
        header.add("Time", "ns", "Timestamp of the snapshot. This timestamp is the start of the snapshot. It is based on unix time");
        header.add("Duration", "ns", "Duration of the snapshot.");
        header.add("PacketCount", "The number of packets received within during the snapshot");
        header.add("Out of order count", "The number of packets received out of order.");
        boolean needsDocumentation = true;
        for (FbFlowInstance flowInstance : data.fbFlows()) {
            FbFlowInstanceReader reader = EntityReaderFactory.create((FbFlowInstance)flowInstance);
            String flowName = reader.getName();
            Set destinations = reader.getDestinationsAndEavesdroppers();
            for (FbDestination destination : destinations) {
                String portName = destination.getPort().getName();
                if (destination.getOutOfSequence() == null) continue;
                FbOutOfSequenceReader fbOutOfSequence = EntityReaderFactory.create((FbOutOfSequence)destination.getOutOfSequence());
                if (needsDocumentation) {
                    printer.title("Frameblasting Out of sequence results over time");
                    header.printDocumentation();
                    needsDocumentation = false;
                }
                printer.printComment("Flow name: " + flowName);
                printer.printComment("Port name: " + portName);
                header.printHeaders();
                EntityManager entityManager = data.entityManager();
                TypedQuery snapshotQuery = fbOutOfSequence.getSnapshotsQuery(entityManager);
                snapshotQuery.setHint("jakarta.persistence.cache.storeMode", (Object)CacheStoreMode.BYPASS);
                snapshotQuery.setHint("eclipselink.maintain-cache", (Object)"False");
                List list = snapshotQuery.getResultList();
                for (FbOutOfSequenceSnapshot snapshot : list) {
                    long time = snapshot.getSnapshotTime();
                    long duration = snapshot.getSnapshotDuration();
                    long ooCount = snapshot.getPacketCountOutOfSequence();
                    long packetCount = snapshot.getPacketCountValid();
                    printer.printRecord(flowName, portName, time, duration, packetCount, ooCount);
                }
                entityManager.close();
                printer.println();
            }
        }
    }
}

