/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.plaintext.BasicPrinter;
import com.excentis.products.byteblower.report.generator.plaintext.CSVItem;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.testdata.data.FbFlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfig;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfigFixedIpv4;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfigFixedIpv6;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatency;
import com.excentis.products.byteblower.results.testdata.data.entities.FbOutOfSequence;
import com.excentis.products.byteblower.results.testdata.data.entities.FbSource;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTrigger;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4Address;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv6Address;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer25;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer25Vlan;
import com.excentis.products.byteblower.results.testdata.data.entities.interfaces.IFbEndpoint;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbTriggerReader;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv4AddressUtility;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv6AddressUtility;
import java.io.IOException;
import java.util.List;
import java.util.Set;

class FrameBlastingTable
implements CSVItem {
    FrameBlastingTable() {
    }

    public boolean getFrameBlastingTxHasVlan(FbTriggerReader sourceTriggerReader, FbSource source) {
        if (sourceTriggerReader == null || source.getPort().getLayer2() == null) {
            return false;
        }
        List vlanlist = source.getPort().getLayer2().getLayer25List();
        for (Layer25 vlan : vlanlist) {
            if (!(vlan instanceof Layer25Vlan)) continue;
            return true;
        }
        return false;
    }

    private String toString(Ipv4Address address) {
        if (address == null) {
            return null;
        }
        return Ipv4AddressUtility.convertToString((byte[])address.getAddress());
    }

    private String toString(Ipv6Address address) {
        if (address == null) {
            return null;
        }
        return Ipv6AddressUtility.convertToExpandedString((byte[])address.getAddress());
    }

    private String describeOddDestination(FbFlowInstance fbFlowInstance) {
        FbDestinationConfig destinationConfig = fbFlowInstance.getDestinationConfig();
        if (destinationConfig instanceof FbDestinationConfigFixedIpv4) {
            FbDestinationConfigFixedIpv4 conf = (FbDestinationConfigFixedIpv4)destinationConfig;
            return this.toString(conf.getIpv4Address());
        }
        if (destinationConfig instanceof FbDestinationConfigFixedIpv6) {
            FbDestinationConfigFixedIpv6 conf = (FbDestinationConfigFixedIpv6)destinationConfig;
            return this.toString(conf.getIpv6Address());
        }
        return "";
    }

    private String describeDestination(FbFlowInstance fbFlowInstance, FbDestination destination) {
        return destination.getPort().getName();
    }

    private long getFrameBlastingByteVlan(IFbEndpoint endPoint, FbTriggerReader triggerReader) {
        if (triggerReader == null || endPoint.getPort().getLayer2() == null) {
            return 0L;
        }
        List vlanlist = endPoint.getPort().getLayer2().getLayer25List();
        int nestingDepth = 0;
        for (Layer25 vlan : vlanlist) {
            if (!(vlan instanceof Layer25Vlan)) continue;
            ++nestingDepth;
        }
        return ((FbTrigger)triggerReader.getEntity()).getPacketCount() * (long)(4 * nestingDepth);
    }

    private long getFrameBlastingDuration(FbTrigger destinationTrigger, FbTrigger sourceTrigger) {
        boolean noRxDuration;
        if (destinationTrigger == null || destinationTrigger.getPacketCount() < 2L) {
            return Long.MIN_VALUE;
        }
        Long firstPacket = destinationTrigger.getFirstPacketTime();
        Long lastPacket = destinationTrigger.getLastPacketTime();
        boolean bl = noRxDuration = firstPacket == null || lastPacket == null;
        if (noRxDuration && sourceTrigger != null && 0L != sourceTrigger.getPacketCount()) {
            firstPacket = sourceTrigger.getFirstPacketTime();
            lastPacket = sourceTrigger.getLastPacketTime();
        }
        if (firstPacket == null || lastPacket == null) {
            return Long.MIN_VALUE;
        }
        return lastPacket - firstPacket;
    }

    private String getFrameBlastingDurationString(FbTrigger destinationTrigger, FbTrigger sourceTrigger) {
        boolean noRxDuration;
        String INVALID = "N/A";
        if (destinationTrigger == null || destinationTrigger.getPacketCount() < 2L) {
            return "N/A";
        }
        Long firstPacket = destinationTrigger.getFirstPacketTime();
        Long lastPacket = destinationTrigger.getLastPacketTime();
        boolean bl = noRxDuration = firstPacket == null || lastPacket == null;
        if (noRxDuration && sourceTrigger != null && 0L != sourceTrigger.getPacketCount()) {
            firstPacket = sourceTrigger.getFirstPacketTime();
            lastPacket = sourceTrigger.getLastPacketTime();
        }
        if (firstPacket == null || lastPacket == null) {
            return "N/A";
        }
        return Long.toString(lastPacket - firstPacket);
    }

    @Override
    public void write(ReportData data, BasicPrinter printer) throws IOException {
        List<FbFlowInstance> fbFlows = data.fbFlows();
        if (fbFlows.isEmpty()) {
            return;
        }
        this.printFBResults(data, printer, fbFlows);
        printer.println();
        this.printOOSResults(data, printer, fbFlows);
        printer.println();
        this.printLatencyResults(data, printer, fbFlows);
        printer.println();
    }

    private void defaultFlowHeader(BasicPrinter.HeaderPrinter header) {
        header.add("Flow", "The name of the flow");
        header.add("Source", "The name of the source ByteBlower port for this flow");
        header.add("Destination", "The name of the destination ByteBlower port of the flow");
    }

    private void printFBResults(ReportData data, BasicPrinter printer, List<FbFlowInstance> fbFlows) throws IOException {
        printer.title("Frameblasting results table");
        BasicPrinter.HeaderPrinter header = printer.headerPrinter();
        this.defaultFlowHeader(header);
        header.add("Tx frames", "The total number of transmitted frames");
        header.add("Rx frames", "The total number of received frames");
        header.add("Frame loss", "%", "The amount of frames lost during transmission");
        header.add("Tx bytes", "byte", "The total number of received bytes. Soley the frame size is counted. The size of the VLAN headers is removed.");
        header.add("Rx bytes", "byte", "The total number of received bytes. Soley the frame size is counted. The size of the VLAN headers is removed.");
        header.add("Byte loss", "%", "The amount of bytes lost during transmission");
        header.add("Duration", "ns", "The time between the first and last received packet. When no duration can be measured, this column has the value 'N/A'. This will happen if no packet is received.");
        header.add("Average throughput", "bit/s", "The average rate of received data over the lifetime of the flow.");
        header.printDocumentation();
        header.printHeaders();
        for (FbFlowInstance flowInstance : fbFlows) {
            FbFlowInstanceReader flowReader = EntityReaderFactory.create((FbFlowInstance)flowInstance);
            String name = flowReader.getName();
            if (!flowReader.isConfigured()) continue;
            FbFlowInstanceManager flowManager = new FbFlowInstanceManager(data.testDataController());
            Set destinations = flowManager.getFbDestinationsAndEavesdroppers(flowInstance);
            for (FbDestination destination : destinations) {
                FbSource source = flowReader.getSource();
                FbTrigger sourceTrigger = source.getTrigger();
                FbTriggerReader sourceTriggerReader = EntityReaderFactory.create((FbTrigger)sourceTrigger);
                FbTrigger destinationTrigger = destination.getTrigger();
                FbTriggerReader destinationTriggerReader = EntityReaderFactory.create((FbTrigger)destinationTrigger);
                String sourceName = source.getPort().getName();
                String destnationName = this.describeDestination(flowInstance, destination);
                long txPackets = sourceTrigger.getPacketCount();
                long rxPackets = destinationTrigger.getPacketCount();
                double packetLoss = (double)(100L * (txPackets - rxPackets)) / (double)txPackets;
                long txBytes = sourceTriggerReader.getByteCount() - this.getFrameBlastingByteVlan((IFbEndpoint)source, sourceTriggerReader);
                long rxBytes = destinationTriggerReader.getByteCount() - this.getFrameBlastingByteVlan((IFbEndpoint)destination, destinationTriggerReader);
                double byteLoss = (double)(100L * (txBytes - rxBytes)) / (double)txBytes;
                String duration = this.getFrameBlastingDurationString(destinationTrigger, sourceTrigger);
                long lduration = this.getFrameBlastingDuration(destinationTrigger, sourceTrigger);
                double avgThroughput = 0.0;
                if (lduration > 0L) {
                    avgThroughput = 8.0E9 * (double)rxBytes / (double)lduration;
                }
                printer.printRecord(name, sourceName, destnationName, txPackets, rxPackets, packetLoss, txBytes, rxBytes, byteLoss, duration, avgThroughput);
            }
            if (!destinations.isEmpty()) continue;
            this.describeOddDestination(flowInstance);
        }
    }

    private void printLatencyHeader(BasicPrinter.HeaderPrinter headerLatency) throws IOException {
        this.defaultFlowHeader(headerLatency);
        headerLatency.add("Min Latency", "ns", "The minimum latency of the received packets");
        headerLatency.add("Avg Latency", "ns", "The average latency of the received packets");
        headerLatency.add("Max Latency", "ns", "The maximum latency of the received packets");
        headerLatency.add("Jitter", "ns", "The jitter of the received packets. This is calculated as the standard deviation of the measured latency");
    }

    private void printLatencyResults(ReportData data, BasicPrinter printer, List<FbFlowInstance> fbFlows) throws IOException {
        printer.title("Latency overview results table");
        BasicPrinter.HeaderPrinter headerLatency = printer.headerPrinter();
        this.printLatencyHeader(headerLatency);
        PrintOnce<BasicPrinter.HeaderPrinter> doHeader = new PrintOnce<BasicPrinter.HeaderPrinter>(this::printLatencyHeader);
        for (FbFlowInstance flowInstance : fbFlows) {
            FbFlowInstanceReader flowReader = EntityReaderFactory.create((FbFlowInstance)flowInstance);
            if (!flowReader.isConfigured()) continue;
            FbFlowInstanceManager flowManager = new FbFlowInstanceManager(data.testDataController());
            Set destinations = flowManager.getFbDestinationsAndEavesdroppers(flowInstance);
            for (FbDestination destination : destinations) {
                FbSource source = flowReader.getSource();
                String name = flowReader.getName();
                String sourceName = source.getPort().getName();
                String destnationName = this.describeDestination(flowInstance, destination);
                FbLatency latency = destination.getLatency();
                if (latency == null || latency.getJitter() == null || latency.getLatencyAverage() == null || latency.getLatencyMinimum() == null || latency.getLatencyMaximum() == null) continue;
                doHeader.printOnceOn(headerLatency);
                long jitter = latency.getJitter();
                long avg = latency.getLatencyAverage();
                long max = latency.getLatencyMaximum();
                long min = latency.getLatencyMinimum();
                printer.printRecord(name, sourceName, destnationName, min, avg, max, jitter);
            }
        }
    }

    private void printOOSHeader(BasicPrinter.HeaderPrinter headerOOS) throws IOException {
        this.defaultFlowHeader(headerOOS);
        headerOOS.add("Frames Out Of Sequence", "The number of frames received out of sequence");
    }

    private void printOOSResults(ReportData data, BasicPrinter printer, List<FbFlowInstance> fbFlows) throws IOException {
        printer.title("Out Of Sequence overview results table");
        BasicPrinter.HeaderPrinter headerPrint = printer.headerPrinter();
        this.printOOSHeader(headerPrint);
        PrintOnce<BasicPrinter.HeaderPrinter> doHeader = new PrintOnce<BasicPrinter.HeaderPrinter>(this::printOOSHeader);
        for (FbFlowInstance flowInstance : fbFlows) {
            FbFlowInstanceReader flowReader = EntityReaderFactory.create((FbFlowInstance)flowInstance);
            String name = flowReader.getName();
            if (!flowReader.isConfigured()) continue;
            FbFlowInstanceManager flowManager = new FbFlowInstanceManager(data.testDataController());
            Set destinations = flowManager.getFbDestinationsAndEavesdroppers(flowInstance);
            for (FbDestination destination : destinations) {
                FbSource source = flowReader.getSource();
                String sourceName = source.getPort().getName();
                String destnationName = this.describeDestination(flowInstance, destination);
                FbOutOfSequence oos = destination.getOutOfSequence();
                if (oos == null || oos.getPacketCountOutOfSequence() == null) continue;
                doHeader.printOnceOn(headerPrint);
                long outOfSequence = oos.getPacketCountOutOfSequence();
                printer.printRecord(name, sourceName, destnationName, outOfSequence);
            }
        }
    }

    private static class PrintOnce<T> {
        private boolean notRunYet = true;
        private final PrintWork<T> printTodo;

        PrintOnce(PrintWork<T> work) {
            this.printTodo = work;
        }

        void printOnceOn(BasicPrinter.HeaderPrinter input) throws IOException {
            if (this.notRunYet) {
                input.printDocumentation();
                input.printHeaders();
                this.notRunYet = false;
            }
        }

        static interface PrintWork<T> {
            public void doPrint(T var1) throws IOException;
        }
    }
}

