/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.plaintext.BasicPrinter;
import com.excentis.products.byteblower.report.generator.plaintext.CSVItem;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTrigger;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTriggerSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbTriggerReader;
import com.excentis.products.byteblower.results.testdata.data.utils.EthernetThroughputType;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.io.IOException;
import java.util.List;
import java.util.Set;

class FrameBlastingThroughputResultsOverTime
implements CSVItem {
    FrameBlastingThroughputResultsOverTime() {
    }

    @Override
    public void write(ReportData data, BasicPrinter printer) throws IOException {
        List<FbFlowInstance> fbFlows = data.fbFlows();
        boolean needsDocumentation = true;
        BasicPrinter.HeaderPrinter receiveHeader = printer.headerPrinter();
        receiveHeader.add("Flow", "The name of the flow");
        receiveHeader.add("Port", "The name of the ByteBlower port.");
        receiveHeader.add("Time", "ns", "Timestamp of the snapshot. This timestamp is the start of the snapshot. It is based on unix time");
        receiveHeader.add("Duration", "ns", "Duration of the snapshot.");
        receiveHeader.add("Rx Packets", "The number of packets received during the snapshot");
        receiveHeader.add("Rx Data", "Bytes", "The amount of data received during the snapshot");
        BasicPrinter.HeaderPrinter transmitHeader = printer.headerPrinter();
        transmitHeader.add("Flow", "The name of the flow");
        transmitHeader.add("Port", "The source port of the flow");
        transmitHeader.add("Time", "ns", "Timestamp of the snapshot. This timestamp is the start of the snapshot. It is based on unix time");
        transmitHeader.add("Duration", "ns", "Duration of the snapshot.");
        transmitHeader.add("Tx Packets", "The number of packets transmitted during the snapshot");
        transmitHeader.add("Tx Data", "Bytes", "The amount of data transmitted during the snapshot");
        for (FbFlowInstance flowInstance : fbFlows) {
            boolean sourceHasData;
            FbFlowInstanceReader reader = EntityReaderFactory.create((FbFlowInstance)flowInstance);
            String flowName = reader.getName();
            Set destinations = reader.getDestinationsAndEavesdroppers();
            if (reader.getSource() == null || reader.getSource().getTrigger() == null) continue;
            FbTriggerReader source = EntityReaderFactory.create((FbTrigger)reader.getSource().getTrigger());
            boolean bl = sourceHasData = source.getThroughputBitsPerSecond(EthernetThroughputType.FRAME_ONLY) != null;
            if (sourceHasData) {
                printer.title("Frameblasting results over time");
                String portName = reader.getSource().getPort().getName();
                transmitHeader.printDocumentation();
                transmitHeader.printHeaders();
                this.printSnapshots(source, data, printer, flowName, portName);
            }
            for (FbDestination destination : destinations) {
                boolean hasData;
                String portName = destination.getPort().getName();
                FbTriggerReader fbTriggerReader = EntityReaderFactory.create((FbTrigger)destination.getTrigger());
                boolean bl2 = hasData = fbTriggerReader.getThroughputBitsPerSecond(EthernetThroughputType.FRAME_ONLY) != null;
                if (!hasData) continue;
                if (needsDocumentation) {
                    printer.title("Frameblasting results over time");
                    receiveHeader.printDocumentation();
                }
                printer.printComment("Flow name: " + flowName);
                printer.printComment("Port name: " + portName);
                receiveHeader.printHeaders();
                this.printSnapshots(fbTriggerReader, data, printer, flowName, portName);
                printer.println();
            }
        }
    }

    private void printSnapshots(FbTriggerReader trigger, ReportData data, BasicPrinter printer, String flowName, String portName) throws IOException {
        EntityManager dataSet = data.entityManager();
        TypedQuery snapshotQuery = trigger.getSnapshotsQuery(dataSet);
        snapshotQuery.setHint("jakarta.persistence.cache.storeMode", (Object)CacheStoreMode.BYPASS);
        snapshotQuery.setHint("eclipselink.maintain-cache", (Object)"False");
        for (FbTriggerSnapshot snapshot : snapshotQuery.getResultList()) {
            long bytes = snapshot.getByteCount();
            long packets = snapshot.getPacketCount();
            long duration = snapshot.getSnapshotDuration();
            long time = snapshot.getSnapshotTime();
            printer.printRecord(flowName, portName, time, duration, packets, bytes);
        }
        dataSet.close();
    }
}

