/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.plaintext.BasicPrinter;
import com.excentis.products.byteblower.report.generator.plaintext.CSVItem;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.testdata.data.NatAddressMappingManager;
import com.excentis.products.byteblower.results.testdata.data.NatPortMappingManager;
import com.excentis.products.byteblower.results.testdata.data.PortManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4NatConfiguration;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4;
import com.excentis.products.byteblower.results.testdata.data.entities.NatAddressMapping;
import com.excentis.products.byteblower.results.testdata.data.entities.NatPortMapping;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.PortReader;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv4AddressUtility;
import java.io.IOException;
import java.util.List;

class IPv4NatPortTable
implements CSVItem {
    private boolean needsHeader = true;

    IPv4NatPortTable() {
    }

    @Override
    public void write(ReportData data, BasicPrinter printer) throws IOException {
        TestDataPersistenceController control = data.testDataController();
        NatAddressMappingManager addressMapManager = new NatAddressMappingManager(control);
        NatPortMappingManager portMapManager = new NatPortMappingManager(control);
        Scenario scenario = data.scenario();
        PortManager portManager = new PortManager(data.testDataController());
        List ports = portManager.getEntities();
        if (ports == null || ports.isEmpty()) {
            return;
        }
        for (Port port : ports) {
            Layer3Ipv4 layer3Ipv4;
            Ipv4NatConfiguration natConfiguration;
            Layer3 layer3 = port.getLayer3();
            if (!(layer3 instanceof Layer3Ipv4) || (natConfiguration = (layer3Ipv4 = (Layer3Ipv4)layer3).getNatConfiguration()) == null) continue;
            this.createHeader(printer);
            List addressMappings = addressMapManager.find(scenario, port);
            for (NatAddressMapping addressMapping : addressMappings) {
                PortReader portReader = EntityReaderFactory.create((Port)port);
                List portMappings = portMapManager.findAll(addressMapping);
                String portPrivate = addressMapping.getTargetPort().getName();
                String portPublic = addressMapping.getResolverPort().getName();
                String privateIp = portReader.getIPv4Address();
                String publicIp = Ipv4AddressUtility.convertToString((byte[])addressMapping.getPublicAddress().getAddress());
                String ipDiscoveryMethod = addressMapping.getMethod();
                for (NatPortMapping portMapping : portMappings) {
                    String protocol = portMapping.getProtocol().name();
                    String privatePort = portMapping.getPrivatePort().toString();
                    String portDiscoveryMethod = portMapping.getMethod();
                    String publicPort = portMapping.getPublicPort().toString();
                    printer.printRecord(portPrivate, portPublic, privateIp, publicIp, ipDiscoveryMethod, protocol, privatePort, publicPort, portDiscoveryMethod);
                }
            }
        }
        printer.println();
    }

    private void createHeader(BasicPrinter printer) throws IOException {
        if (this.needsHeader) {
            printer.title("IPv4 Nat translation results");
            BasicPrinter.HeaderPrinter header = printer.headerPrinter();
            header.add("Private BB port", "The name of the ByteBlower port in the private network. The NATDiscovery is launched from this port.");
            header.add("Public BB port", "The name of the ByteBlower port in the public network. This port is the target of the NATDiscovery.");
            header.add("Private IPv4", "The private IPv4 addres.");
            header.add("Public IPv4", "The discovered public IPv4 addres.");
            header.add("IP method", "The method used to discover the IPv4 addres.");
            header.add("Protocol", "The protocol used to compose the discovery packet.");
            header.add("Private L4 port", "The Layer 4 (TCP/UDP) port in the private network.");
            header.add("Public L4 port", "The discovered Layer 4 (TCP/UDP) port.");
            header.add("L4 port discovery", "The method used to discovert Layer 4 (TCP/UDP) ports.");
            header.printDocumentation();
            header.printHeaders();
        }
        this.needsHeader = false;
    }
}

