/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.plaintext.BasicPrinter;
import com.excentis.products.byteblower.report.generator.plaintext.CSVItem;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.testdata.data.PortManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.PortGroup;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.PortReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;

class IPv4PortTable
implements CSVItem {
    private static String EMPTY_GROUP = "";
    private boolean needsHeader = true;

    IPv4PortTable() {
    }

    @Override
    public void write(ReportData data, BasicPrinter printer) throws IOException {
        TestDataPersistenceController control = data.testDataController();
        PortManager portManager = new PortManager(control);
        List ports = portManager.getEntities();
        HashSet seen = new HashSet();
        if (ports == null || ports.isEmpty()) {
            return;
        }
        for (PortGroup group : PortGroup.all((TestDataPersistenceController)data.testDataController())) {
            this.printGroup(printer, group);
            seen.addAll(group.getMembers());
        }
        for (Port port : ports) {
            if (seen.contains(port)) continue;
            this.addPort(printer, EMPTY_GROUP, port);
        }
        printer.println();
    }

    private void printGroup(BasicPrinter printer, PortGroup group) throws IOException {
        for (Port port : group.getMembers()) {
            this.addPort(printer, group.getName(), port);
        }
    }

    private void addPort(BasicPrinter printer, String groupName, Port port) throws IOException {
        if (port.getLayer2() == null) {
            this.createHeader(printer);
            this.addWirelessPort(printer, groupName, port);
        } else if (port.getLayer3() instanceof Layer3Ipv4) {
            this.createHeader(printer);
            this.addBBPort(printer, groupName, port);
        }
    }

    private void addBBPort(BasicPrinter printer, String groupName, Port port) throws IOException {
        PortReader portReader = EntityReaderFactory.create((Port)port);
        String name = portReader.getName();
        String mac = portReader.getMac();
        String ipv4 = portReader.getIPv4Address();
        String ipv4Gw = portReader.getIPv4Gateway();
        String ipv4NetMask = portReader.getIpv4Netmask();
        String nat = portReader.getNat();
        String VLAN = portReader.getVlan();
        String MTU = portReader.getMtu().toString();
        String docked = portReader.getDocked();
        printer.printRecord(name, groupName, mac, ipv4, ipv4Gw, ipv4NetMask, nat, VLAN, MTU, docked);
    }

    private void addWirelessPort(BasicPrinter printer, String groupName, Port port) throws IOException {
        PortReader portReader = EntityReaderFactory.create((Port)port);
        String name = portReader.getName();
        String mac = "Mobile app";
        String ipv4 = portReader.getIPv4Address();
        String ipv4Gw = "Mobile app";
        String ipv4NetMask = "Mobile app";
        String nat = portReader.getNat();
        String VLAN = "No";
        String MTU = "1500";
        String docked = portReader.getDocked();
        printer.printRecord(name, groupName, mac, ipv4, ipv4Gw, ipv4NetMask, nat, VLAN, MTU, docked);
    }

    private void createHeader(BasicPrinter printer) throws IOException {
        if (this.needsHeader) {
            printer.title("IPv4 ByteBlower Port configuration");
            BasicPrinter.HeaderPrinter header = printer.headerPrinter();
            header.add("Name", "The name of the port");
            header.add("Group", "The name of the portgroup. Empty if the port doesn't belong to any group.");
            header.add("MAC", "The configured MAC address of the port.");
            header.add("IPv4 address", "The IPv4 address of the port.");
            header.add("Gateway", "The gateway used by the port.");
            header.add("Netmask", "The netmask used by the port.");
            header.add("NAT enabled", "Empty when no NAT is expected on the port, Yes for the default automatic NAT discovery or the Name of the configured port mapping.");
            header.add("VLAN", "The configured VLAN stack");
            header.add("MTU", "bytes", "The Maximum Transmit Unit (MTU) of this port");
            header.add("Docked", "Additional information on where the port is docked");
            header.printDocumentation();
            header.printHeaders();
        }
        this.needsHeader = false;
    }
}

