/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.plaintext.BasicPrinter;
import com.excentis.products.byteblower.report.generator.plaintext.CSVItem;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.testdata.data.PortManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.PortGroup;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.PortReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;

class IPv6PortTable
implements CSVItem {
    private static String EMPTY_GROUP = "";
    private boolean needsHeader = true;

    IPv6PortTable() {
    }

    @Override
    public void write(ReportData data, BasicPrinter printer) throws IOException {
        PortManager portManager = new PortManager(data.testDataController());
        List ports = portManager.getEntities();
        HashSet<Port> seen = new HashSet<Port>();
        if (ports == null || ports.isEmpty()) {
            return;
        }
        for (PortGroup group : PortGroup.all((TestDataPersistenceController)data.testDataController())) {
            for (Port port : group.getMembers()) {
                seen.add(port);
                this.writePort(printer, group.getName(), port);
            }
        }
        for (Port port : ports) {
            this.writePort(printer, EMPTY_GROUP, port);
        }
    }

    private void writePort(BasicPrinter printer, String group, Port port) throws IOException {
        if (port.getLayer3() instanceof Layer3Ipv6) {
            this.createHeader(printer);
            PortReader portReader = EntityReaderFactory.create((Port)port);
            String name = portReader.getName();
            String mac = portReader.getMac();
            String firstPublic = portReader.getIPv6AddressFirstPublic();
            String router = portReader.getIPv6GatewayFirst();
            String prefix = portReader.getIPv6PrefixLengthFirstPublic();
            String vlan = portReader.getVlan();
            Integer mtu = portReader.getMtu();
            String docked = portReader.getDocked();
            printer.printRecord(name, group, mac, firstPublic, router, prefix, vlan, mtu, docked);
        }
    }

    private void createHeader(BasicPrinter printer) throws IOException {
        if (this.needsHeader) {
            printer.title("IPv6 ByteBlower Port configuration");
            BasicPrinter.HeaderPrinter header = printer.headerPrinter();
            header.add("Name", "The name of the port");
            header.add("Group", "The ByteBlower port group of the port");
            header.add("MAC", "The configured MAC address of the port");
            header.add("IPv6 address", "The first public IPv6 of the port.");
            header.add("Router address", "The IPv6 address of the router.");
            header.add("Prefix length", "bits", "The length of the prefix");
            header.add("VLAN", "The configured VLAN stack");
            header.add("MTU", "bytes", "The Maximum Transmit Unit (MTU) of this port");
            header.add("Docked", "Additional information on where the port is docked");
            header.printDocumentation();
            header.printHeaders();
        }
        this.needsHeader = false;
    }
}

