/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.plaintext.BasicPrinter;
import com.excentis.products.byteblower.report.generator.plaintext.CSVItem;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatencyDistribution;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

class LatencyDistributionChart
implements CSVItem {
    LatencyDistributionChart() {
    }

    @Override
    public void write(ReportData data, BasicPrinter printer) throws IOException {
        List<FbFlowInstance> fbFlows = data.fbFlows();
        BasicPrinter.HeaderPrinter header = printer.headerPrinter();
        header.add("Flow", "The name of the flow with latency histogram measurement");
        header.add("BB port", "The ByteBlower port where the traffic arrives");
        header.add("Start", "ns", "The start of the latency range");
        header.add("End", "ns", "The end of the latency range");
        header.add("Packets", "The number of packets with a latency between Start and End");
        boolean needsDocumentation = true;
        for (FbFlowInstance flowInstance : fbFlows) {
            FbFlowInstanceReader reader = EntityReaderFactory.create((FbFlowInstance)flowInstance);
            String flowName = reader.getName();
            Set destinations = reader.getDestinationsAndEavesdroppers();
            for (FbDestination destination : destinations) {
                long approxDurationNs;
                String portName = destination.getPort().getName();
                if (destination.getLatency() == null || destination.getLatency().getDistribution() == null) continue;
                FbLatencyDistribution distribution = destination.getLatency().getDistribution();
                if (needsDocumentation) {
                    printer.title("Frameblasting latency histogram");
                    header.printDocumentation();
                    needsDocumentation = false;
                }
                printer.printComment("Flow name: " + flowName);
                printer.printComment("Port name: " + portName);
                header.printHeaders();
                ArrayList<Mapping> buckets = new ArrayList<Mapping>();
                if (distribution.getLatencyRangeMinimum() > 0L) {
                    buckets.add(new Mapping(0L, distribution.getLatencyRangeMinimum(), distribution.getPacketCountBelowMinimum()));
                }
                long width = distribution.getBucketWidth();
                for (Map.Entry bucket : distribution.getEntries().entrySet()) {
                    long packets = (Long)bucket.getValue();
                    long start = (Long)bucket.getKey();
                    long end = start + width;
                    buckets.add(new Mapping(start, end, packets));
                }
                Scenario scenario = data.scenario();
                if (scenario.getRunEndTime() != null && scenario.getRunStartTime() != null) {
                    long approxDurationMs = scenario.getRunEndTime().getTime() - scenario.getRunStartTime().getTime();
                    approxDurationNs = TimeUnit.MILLISECONDS.toNanos(approxDurationMs);
                } else {
                    approxDurationNs = Long.MAX_VALUE;
                }
                buckets.add(new Mapping(distribution.getLatencyRangeMaximum(), Math.max(approxDurationNs, distribution.getLatencyRangeMaximum() + 1L), distribution.getPacketCountAboveMaximum()));
                Collections.sort(buckets);
                for (Mapping bucket : buckets) {
                    printer.printRecord(flowName, portName, bucket.bucketStart, bucket.bucketEnd, bucket.packetCount);
                }
                printer.println();
            }
        }
    }

    private static class Mapping
    implements Comparable<Mapping> {
        final long bucketStart;
        final long packetCount;
        final long bucketEnd;

        public Mapping(long bucketStart, long bucketEnd, long packetCount) {
            this.bucketStart = bucketStart;
            this.bucketEnd = bucketEnd;
            this.packetCount = packetCount;
        }

        public int hashCode() {
            return (int)((this.bucketStart << 16) + this.packetCount + this.bucketEnd);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Mapping other = (Mapping)obj;
            return this.bucketStart == other.bucketStart && this.packetCount == other.packetCount;
        }

        @Override
        public int compareTo(Mapping o) {
            return Long.compare(this.bucketStart, o.bucketStart);
        }
    }
}

