/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.plaintext.BasicPrinter;
import com.excentis.products.byteblower.report.generator.plaintext.CSVItem;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.testdata.data.FbFlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfig;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfigFixedIpv4;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfigFixedIpv6;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatency;
import com.excentis.products.byteblower.results.testdata.data.entities.FbSource;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTrigger;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4Address;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv6Address;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv4AddressUtility;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv6AddressUtility;
import java.io.IOException;
import java.util.List;
import java.util.Set;

class LatencyTable
implements CSVItem {
    LatencyTable() {
    }

    private static String toString(Ipv4Address address) {
        if (address == null) {
            return "";
        }
        return Ipv4AddressUtility.convertToString((byte[])address.getAddress());
    }

    private static String toString(Ipv6Address address) {
        if (address == null) {
            return "";
        }
        return Ipv6AddressUtility.convertToExpandedString((byte[])address.getAddress());
    }

    private String getDestination(FbFlowInstance fbFlowInstance, FbDestination destination) {
        if (destination == null) {
            FbDestinationConfig destinationConfig = fbFlowInstance.getDestinationConfig();
            if (destinationConfig instanceof FbDestinationConfigFixedIpv4) {
                FbDestinationConfigFixedIpv4 conf = (FbDestinationConfigFixedIpv4)destinationConfig;
                return LatencyTable.toString(conf.getIpv4Address());
            }
            if (destinationConfig instanceof FbDestinationConfigFixedIpv6) {
                FbDestinationConfigFixedIpv6 conf = (FbDestinationConfigFixedIpv6)destinationConfig;
                return LatencyTable.toString(conf.getIpv6Address());
            }
            return "";
        }
        return destination.getPort().getName();
    }

    @Override
    public void write(ReportData data, BasicPrinter printer) throws IOException {
        List<FbFlowInstance> fbFlows = data.fbFlows();
        if (fbFlows.isEmpty()) {
            return;
        }
        printer.title("Frameblasting latency results table");
        BasicPrinter.HeaderPrinter header = this.createHeader(printer);
        boolean hasDocumentation = false;
        for (FbFlowInstance flowInstance : fbFlows) {
            FbFlowInstanceReader flowReader = EntityReaderFactory.create((FbFlowInstance)flowInstance);
            String name = flowReader.getName();
            if (!flowReader.isConfigured()) continue;
            FbFlowInstanceManager flowManager = new FbFlowInstanceManager(data.testDataController());
            Set destinations = flowManager.getFbDestinationsAndEavesdroppers(flowInstance);
            FbSource source = flowReader.getSource();
            String sourceName = source.getPort().getName();
            for (FbDestination destination : destinations) {
                FbTrigger destinationTrigger = destination.getTrigger();
                String destnationName = this.getDestination(flowInstance, destination);
                FbLatency latency = destination.getLatency();
                if (latency == null || latency.getJitter() == null || latency.getLatencyAverage() == null || latency.getLatencyMinimum() == null || latency.getLatencyMaximum() == null) continue;
                if (!hasDocumentation) {
                    hasDocumentation = true;
                    header.printDocumentation();
                    header.printHeaders();
                }
                long rxPackets = destinationTrigger.getPacketCount();
                long jitter = latency.getJitter();
                long avg = latency.getLatencyAverage();
                long max = latency.getLatencyMaximum();
                long min = latency.getLatencyMinimum();
                printer.printRecord(name, sourceName, destnationName, rxPackets, min, avg, max, jitter);
            }
        }
        printer.println();
    }

    private BasicPrinter.HeaderPrinter createHeader(BasicPrinter printer) {
        BasicPrinter.HeaderPrinter header = printer.headerPrinter();
        header.add("Flow", "The name of the flow");
        header.add("Source", "The name of the source ByteBlower port for this flow");
        header.add("Destination", "The name of the destination ByteBlower port of the flow");
        header.add("Rx frames", "The total number of frames with latency measurement");
        header.add("Minimum Latency", "ns", "The minimum latency measured over the lifetime of the flow");
        header.add("Average Latency", "ns", "The average latency measured over the lifetime of the flow");
        header.add("Maximum Latency", "ns", "The maximum latency measured over the lifetime of the flow. Only actually received packets are counted.");
        header.add("Jitter", "ns", "The measured jitter of the latency. This is calculated as the standard deviation of the latency samples.");
        return header;
    }
}

