/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.plaintext.BasicPrinter;
import com.excentis.products.byteblower.report.generator.plaintext.CSVItem;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.testdata.data.FbFlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfig;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfigFixedIpv4;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfigFixedIpv6;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbOutOfSequence;
import com.excentis.products.byteblower.results.testdata.data.entities.FbSource;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTrigger;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4Address;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv6Address;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv4AddressUtility;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv6AddressUtility;
import java.io.IOException;
import java.util.List;
import java.util.Set;

class OOSTable
implements CSVItem {
    OOSTable() {
    }

    private String toString(Ipv4Address address) {
        if (address == null) {
            return null;
        }
        return Ipv4AddressUtility.convertToString((byte[])address.getAddress());
    }

    private String toString(Ipv6Address address) {
        if (address == null) {
            return null;
        }
        return Ipv6AddressUtility.convertToExpandedString((byte[])address.getAddress());
    }

    private String getDestination(FbFlowInstance fbFlowInstance, FbDestination destination) {
        if (destination == null) {
            FbDestinationConfig destinationConfig = fbFlowInstance.getDestinationConfig();
            if (destinationConfig instanceof FbDestinationConfigFixedIpv4) {
                FbDestinationConfigFixedIpv4 conf = (FbDestinationConfigFixedIpv4)destinationConfig;
                return this.toString(conf.getIpv4Address());
            }
            if (destinationConfig instanceof FbDestinationConfigFixedIpv6) {
                FbDestinationConfigFixedIpv6 conf = (FbDestinationConfigFixedIpv6)destinationConfig;
                return this.toString(conf.getIpv6Address());
            }
            return new String();
        }
        return destination.getPort().getName();
    }

    @Override
    public void write(ReportData data, BasicPrinter printer) throws IOException {
        List<FbFlowInstance> fbFlows = data.fbFlows();
        if (fbFlows.isEmpty()) {
            return;
        }
        printer.title("Frameblasting Out of Sequence results table");
        BasicPrinter.HeaderPrinter header = printer.headerPrinter();
        header.add("Flow", "The name of the flow");
        header.add("Source", "The name of the source ByteBlower port for this flow");
        header.add("Destination", "The name of the destination ByteBlower port of the flow");
        header.add("Rx frames", "The total number of frames with latency measurement");
        header.add("Out of Sequence frames", "The total number of frames out of sequence");
        boolean hasDocumentation = false;
        for (FbFlowInstance flowInstance : fbFlows) {
            FbFlowInstanceReader flowReader = EntityReaderFactory.create((FbFlowInstance)flowInstance);
            String name = flowReader.getName();
            if (!flowReader.isConfigured()) continue;
            FbFlowInstanceManager flowManager = new FbFlowInstanceManager(data.testDataController());
            Set destinations = flowManager.getFbDestinationsAndEavesdroppers(flowInstance);
            for (FbDestination destination : destinations) {
                FbSource source = flowReader.getSource();
                FbTrigger destinationTrigger = destination.getTrigger();
                String sourceName = source.getPort().getName();
                String destnationName = this.getDestination(flowInstance, destination);
                long rxPackets = destinationTrigger.getPacketCount();
                FbOutOfSequence oos = destination.getOutOfSequence();
                if (oos == null || oos.getPacketCountOutOfSequence() == null) continue;
                if (!hasDocumentation) {
                    hasDocumentation = true;
                    header.printDocumentation();
                    header.printHeaders();
                }
                printer.printRecord(name, sourceName, destnationName, rxPackets, oos.getPacketCountOutOfSequence());
            }
        }
        printer.println();
    }
}

