/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.plaintext.BasicPrinter;
import com.excentis.products.byteblower.results.dataprovider.plugin.Activator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

class Printer
extends BasicPrinter {
    private final CSVPrinter basePrinter;

    Printer(File destination) throws IOException {
        CSVFormat format = CSVFormat.DEFAULT.withCommentMarker('#');
        this.basePrinter = format.print((Appendable)new FileWriter(destination));
    }

    @Override
    public void printComment(String cmt) throws IOException {
        this.basePrinter.printComment(cmt);
    }

    @Override
    public BasicPrinter.HeaderPrinter headerPrinter() {
        return new BasicPrinter.HeaderPrinter(this);
    }

    @Override
    public void printRecord(Object ... values) throws IOException {
        if (this.lastColumnEstimate != values.length) {
            String callerDescription = this.getCaller();
            String message = String.format("%s: Expected %d columns - got %d", callerDescription, this.lastColumnEstimate, values.length);
            Status st = new Status(2, "com.excentis.products.byteblower.results.dataprovider.plugin", message);
            Activator.getDefault().getLog().log((IStatus)st);
        }
        this.basePrinter.printRecord(values);
    }

    @Override
    public void println() throws IOException {
        this.basePrinter.println();
    }

    @Override
    public void close() throws Exception {
        this.basePrinter.close();
    }

    @Override
    public void title(String string) throws IOException {
        StringBuilder line = new StringBuilder();
        int ctr = 0;
        while (ctr < string.length()) {
            line.append('-');
            ++ctr;
        }
        this.basePrinter.println();
        this.basePrinter.printComment(string);
        this.basePrinter.printComment(line.toString());
    }
}

