/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import com.excentis.products.byteblower.report.generator.core.parameters.ThroughputTypeParameter;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.testdata.data.FlowInstanceManager;
import com.excentis.products.byteblower.results.testdata.data.ScenarioManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.Scenario;
import jakarta.persistence.EntityManager;
import java.util.List;

public class ReportData {
    private TestDataReference testdata;
    private long testId;
    private TestDataPersistenceController control;
    private String scenarioName;
    private Scenario scenario;
    private ReportPreferencesInterface preferences;

    public ReportData(ReportGeneration reportGeneration, ReportPreferencesInterface pref) {
        this.preferences = pref;
        this.testdata = reportGeneration.getTestDataReference();
        this.testId = this.testdata.getId();
        this.control = TestDataPersistenceController.getInstance((Long)this.testId);
        this.scenarioName = this.testdata.getTestName();
        ScenarioManager scmanager = new ScenarioManager(this.control);
        this.scenario = scmanager.find(this.scenarioName);
    }

    public Scenario scenario() {
        return this.scenario;
    }

    public TestDataPersistenceController testDataController() {
        return this.control;
    }

    public long getTestId() {
        return this.testId;
    }

    public ThroughputTypeParameter getThroughputType() {
        return this.preferences.getThroughputType();
    }

    List<FbFlowInstance> fbFlows() {
        FlowInstanceManager manager = new FlowInstanceManager(this.control);
        return manager.getAllFrameBlasting(this.scenario);
    }

    public List<FlowInstance> allFlows() {
        FlowInstanceManager manager = new FlowInstanceManager(this.control);
        return manager.getAll(this.scenario);
    }

    public List<HttpFlowInstance> tcpFlows() {
        FlowInstanceManager manager = new FlowInstanceManager(this.control);
        return manager.getAllTcp(this.scenario);
    }

    EntityManager entityManager() {
        return this.control.createEntityManager();
    }

    public TestDataReference getDataReference() {
        return this.testdata;
    }

    public String getOutputLocation() {
        return this.preferences.getOutputLocation();
    }
}

