/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.data.entities.core.ReportOutputFormat;
import com.excentis.products.byteblower.report.data.entities.templates.ReportTemplateEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.ErrorInfoTableWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.FrameBlastingInfoTableWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.FrameBlastingLatencyTableWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.FrameBlastingOosTableWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.FrameBlastingOverTimeThroughputWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.FrameBlastingTableWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.IPv4NatPortTableWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.IPv4PortsWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.IPv6PortsWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.InfoTableWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.LatencyDistributionChartWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.LatencyResultsOverTimeChartsWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.LossLegendWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.OosResultsOverTimeChartsWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.PortOverviewWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.RSSIOverTimeWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.ReportItemWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.ReportTitleWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.Rfc2544ThroughputResultsWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.ScenarioInfoWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.TCPResultsOverTimeChartsWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.TcpAggregateRxWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.TcpAggregateTxWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.TcpInfoWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.TcpRTTTableWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.TcpTableWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.ThroughputLegendWidgetEntity;
import com.excentis.products.byteblower.report.data.entities.widgets.WarningInfoTableWidgetEntity;
import com.excentis.products.byteblower.report.generator.core.AbstractReportManager;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import com.excentis.products.byteblower.report.generator.plaintext.CSVItem;
import com.excentis.products.byteblower.report.generator.plaintext.EmptyItem;
import com.excentis.products.byteblower.report.generator.plaintext.EventTable;
import com.excentis.products.byteblower.report.generator.plaintext.FrameBlastingInfoTable;
import com.excentis.products.byteblower.report.generator.plaintext.FrameBlastingLatencyResultsOverTime;
import com.excentis.products.byteblower.report.generator.plaintext.FrameBlastingOOResultsOverTime;
import com.excentis.products.byteblower.report.generator.plaintext.FrameBlastingTable;
import com.excentis.products.byteblower.report.generator.plaintext.FrameBlastingThroughputResultsOverTime;
import com.excentis.products.byteblower.report.generator.plaintext.IPv4NatPortTable;
import com.excentis.products.byteblower.report.generator.plaintext.IPv4PortTable;
import com.excentis.products.byteblower.report.generator.plaintext.IPv6PortTable;
import com.excentis.products.byteblower.report.generator.plaintext.LatencyDistributionChart;
import com.excentis.products.byteblower.report.generator.plaintext.LatencyTable;
import com.excentis.products.byteblower.report.generator.plaintext.OOSTable;
import com.excentis.products.byteblower.report.generator.plaintext.Printer;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.report.generator.plaintext.Rfc2544ThroughputResults;
import com.excentis.products.byteblower.report.generator.plaintext.RssiOverTimeResults;
import com.excentis.products.byteblower.report.generator.plaintext.ScenarioInfo;
import com.excentis.products.byteblower.report.generator.plaintext.TcpAggregateRx;
import com.excentis.products.byteblower.report.generator.plaintext.TcpAggregateTx;
import com.excentis.products.byteblower.report.generator.plaintext.TcpInfo;
import com.excentis.products.byteblower.report.generator.plaintext.TcpResultsOverTime;
import com.excentis.products.byteblower.report.generator.plaintext.TcpTable;
import com.excentis.products.byteblower.report.generator.plaintext.Title;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public class ReportManagerPlainText
extends AbstractReportManager {
    public void createReport(ReportGeneration reportGeneration, ReportTemplateEntity reportTemplate, ReportPreferencesInterface pref, GenerateReportListener listener, IProgressMonitor monitor) {
        Logger logger = Logger.getGlobal();
        ReportData data = new ReportData(reportGeneration, pref);
        String filename = ReportManagerPlainText.getFileName((ReportPreferencesInterface)pref, (ReportGeneration)reportGeneration, (ReportOutputFormat)ReportOutputFormat.csv);
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (Printer writer = new Printer(new File(filename));){
                for (ReportItemWidgetEntity widget : reportTemplate.getReportItemWidgets()) {
                    CSVItem item = ReportManagerPlainText.partFactory(widget);
                    item.write(data, writer);
                }
                listener.onReportExported(reportGeneration, filename, ReportOutputFormat.csv);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Could not save CSV", ex);
        }
    }

    private static CSVItem partFactory(ReportItemWidgetEntity widget) {
        if (widget instanceof ReportTitleWidgetEntity) {
            return new Title();
        }
        if (widget instanceof ScenarioInfoWidgetEntity) {
            return new ScenarioInfo();
        }
        if (widget instanceof LossLegendWidgetEntity) {
            return new EmptyItem();
        }
        if (widget instanceof PortOverviewWidgetEntity) {
            return new IPv4PortTable();
        }
        if (widget instanceof ThroughputLegendWidgetEntity) {
            return new EmptyItem();
        }
        if (widget instanceof IPv4PortsWidgetEntity) {
            return new IPv4PortTable();
        }
        if (widget instanceof IPv4NatPortTableWidgetEntity) {
            return new IPv4NatPortTable();
        }
        if (widget instanceof IPv6PortsWidgetEntity) {
            return new IPv6PortTable();
        }
        if (widget instanceof FrameBlastingTableWidgetEntity) {
            return new FrameBlastingTable();
        }
        if (widget instanceof FrameBlastingLatencyTableWidgetEntity) {
            return new LatencyTable();
        }
        if (widget instanceof FrameBlastingOosTableWidgetEntity) {
            return new OOSTable();
        }
        if (widget instanceof FrameBlastingInfoTableWidgetEntity) {
            return new FrameBlastingInfoTable();
        }
        if (widget instanceof FrameBlastingOverTimeThroughputWidgetEntity) {
            return new FrameBlastingThroughputResultsOverTime();
        }
        if (widget instanceof LatencyResultsOverTimeChartsWidgetEntity) {
            return new FrameBlastingLatencyResultsOverTime();
        }
        if (widget instanceof LatencyDistributionChartWidgetEntity) {
            return new LatencyDistributionChart();
        }
        if (widget instanceof OosResultsOverTimeChartsWidgetEntity) {
            return new FrameBlastingOOResultsOverTime();
        }
        if (widget instanceof TcpTableWidgetEntity) {
            return new TcpTable();
        }
        if (widget instanceof TcpRTTTableWidgetEntity) {
            return new EmptyItem();
        }
        if (widget instanceof TCPResultsOverTimeChartsWidgetEntity) {
            return new TcpResultsOverTime();
        }
        if (widget instanceof TcpInfoWidgetEntity) {
            return new TcpInfo();
        }
        if (widget instanceof TcpAggregateTxWidgetEntity) {
            return new TcpAggregateTx();
        }
        if (widget instanceof TcpAggregateRxWidgetEntity) {
            return new TcpAggregateRx();
        }
        if (widget instanceof InfoTableWidgetEntity) {
            return new EventTable("Info", EventSeverity.TEST_INFO, EventSeverity.TEST_SUGGESTION);
        }
        if (widget instanceof WarningInfoTableWidgetEntity) {
            return new EventTable("Warnings", EventSeverity.TEST_WARNING);
        }
        if (widget instanceof ErrorInfoTableWidgetEntity) {
            return new EventTable("Errors", EventSeverity.TEST_ERROR);
        }
        if (widget instanceof Rfc2544ThroughputResultsWidgetEntity) {
            return new Rfc2544ThroughputResults();
        }
        if (widget instanceof RSSIOverTimeWidgetEntity) {
            return new RssiOverTimeResults();
        }
        return new EmptyItem();
    }
}

