/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.plaintext.BasicPrinter;
import com.excentis.products.byteblower.report.generator.plaintext.CSVItem;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.testdata.data.BaseEntityManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowTemplate;
import com.excentis.products.byteblower.results.testdata.data.entities.ThroughputFlowResult;
import com.excentis.products.byteblower.results.testdata.data.entities.ThroughputFlowTest;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowTemplateReader;
import java.io.IOException;
import java.util.List;

class Rfc2544ThroughputResults
implements CSVItem {
    Rfc2544ThroughputResults() {
    }

    @Override
    public void write(ReportData data, BasicPrinter printer) throws IOException {
        TestDataPersistenceController controller = data.testDataController();
        BaseEntityManager tt = new BaseEntityManager(ThroughputFlowTest.class, controller);
        List tests = tt.getEntities();
        if (tests.isEmpty()) {
            return;
        }
        BasicPrinter.HeaderPrinter header = printer.headerPrinter();
        header.add("Source", "The source Byteblower port");
        header.add("Destination", "The destination ByteBlower port");
        header.add("Dramesize", "bytes", "The size of the packets used");
        header.add("Interframe gap", "ns", "The current interframe gap");
        header.add("Iteration duration ", "ns", "The dutation of this iteration.");
        header.add("Tx ", "bytes", "The configured amount of packets.");
        header.add("Rx", "bytes", "The received count of packets");
        header.add("Rx throughput", "Mbit/s", "The received bandwidth");
        header.add("Lossrate", "loss rate of the iteration. A value between 0 (all lost) and 1 (no loss)");
        header.printDocumentation();
        header.printHeaders();
        for (ThroughputFlowTest test : tt.getEntities()) {
            String sourceName = test.getSource().getName();
            String destName = test.getDestination().getName();
            FbFlowTemplateReader templateReader = EntityReaderFactory.create((FbFlowTemplate)test.getFlowTemplate());
            for (ThroughputFlowResult r : test.getResults()) {
                double rxBandwidth = (double)(8L * r.getRxBytes()) * 1.0E9 / (double)(1000000L * r.getDuration());
                double lossrate = r.getTxBytes() == 0L ? 0.0 : (double)r.getRxBytes() / (double)r.getTxBytes();
                printer.printRecord(sourceName, destName, templateReader.getFrameSizeInfo(), r.getFrameInterval(), r.getDuration(), r.getTxBytes(), r.getRxBytes(), rxBandwidth, lossrate);
            }
        }
    }
}

