/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.plaintext.BasicPrinter;
import com.excentis.products.byteblower.report.generator.plaintext.CSVItem;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.WiFiSample;
import java.io.IOException;
import java.util.HashMap;
import java.util.TreeMap;

public class RssiOverTimeResults
implements CSVItem {
    @Override
    public void write(ReportData data, BasicPrinter printer) throws IOException {
        HashMap<String, TreeMap<Long, WiFiSample>> byDevice = RssiOverTimeResults.fetchSamples(data);
        printer.title("Wi-Fi Statistics");
        BasicPrinter.HeaderPrinter headers = printer.headerPrinter();
        headers.add("Timestamp", "Moment when the Wi-Fi stats were collected");
        headers.add("ByteBlower Port", "Name of the ByteBlower Port where the Wireless Endpoint is docker to.");
        headers.add("Network interface", "Name of the Network interface.");
        headers.add("SSID", "SSID of the connected Wi-Fi AP. Empty in case of no connection.");
        headers.add("BSSID", "BSSID of the connected Wi-Fi AP. Zeroes in case of no connection.");
        headers.add("RSSI", "RSSI of the Wi-Fi signal.");
        headers.printDocumentation();
        headers.printHeaders();
        for (TreeMap<Long, WiFiSample> byTime : byDevice.values()) {
            for (WiFiSample sample : byTime.values()) {
                String wepName = sample.getPortname();
                String nicName = sample.getNetinterface();
                long timeStamp = sample.getTimestamp();
                String bssid = sample.getBssid();
                String ssid = sample.getSsid();
                long rssi = sample.getRssi();
                printer.printRecord(timeStamp, wepName, nicName, ssid, bssid, rssi);
            }
        }
    }

    private static HashMap<String, TreeMap<Long, WiFiSample>> fetchSamples(ReportData data) {
        HashMap<String, TreeMap<Long, WiFiSample>> byDevice = new HashMap<String, TreeMap<Long, WiFiSample>>();
        for (WiFiSample sample : WiFiSample.getSamples((TestDataPersistenceController)data.testDataController())) {
            String key = String.valueOf(sample.getPortname()) + " -- " + sample.getNetinterface();
            byDevice.computeIfAbsent(key, k -> new TreeMap()).put(sample.getTimestamp(), sample);
        }
        return byDevice;
    }
}

