/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.plaintext.BasicPrinter;
import com.excentis.products.byteblower.report.generator.plaintext.CSVItem;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.results.testdata.data.ServerManager;
import com.excentis.products.byteblower.results.testdata.data.entities.Server;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv4AddressUtility;
import java.io.IOException;

class ScenarioInfo
implements CSVItem {
    ScenarioInfo() {
    }

    @Override
    public void write(ReportData data, BasicPrinter printer) throws IOException {
        TestDataReference testdata = data.getDataReference();
        String author = testdata.getProjectAuthor();
        printer.printComment("ByteBlower CSV results.");
        printer.printComment("Author: " + author);
        printer.printComment("Project name: " + testdata.getProjectName());
        printer.printComment("Project version: " + testdata.getProjectVersion());
        printer.printComment("Test started at " + testdata.getStartTime() + " till " + testdata.getEndTime());
        printer.printComment("Test name " + testdata.getTestName());
        if (testdata.getTestType() == null) {
            printer.printComment("Test type: Not configured yet");
        } else {
            printer.printComment("Test type: " + testdata.getTestType().toString());
        }
        ServerManager servers = new ServerManager(data.testDataController());
        for (Server server : servers.getEntities()) {
            StringBuilder buffer = new StringBuilder();
            String name = server.getName();
            String addr = "Unknown";
            if (server.getIpv4Address() != null) {
                addr = Ipv4AddressUtility.convertToString((byte[])server.getIpv4Address().getAddress());
            }
            buffer.append(name);
            if (!name.equals(addr)) {
                buffer.append(" [");
                buffer.append(addr);
                buffer.append("]");
            }
            buffer.append(":: ");
            buffer.append(server.getType());
            buffer.append(" - ");
            buffer.append(server.getVersion());
            printer.printComment(buffer.toString());
        }
        printer.println();
        printer.println();
    }
}

