/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.plaintext.BasicPrinter;
import com.excentis.products.byteblower.report.generator.plaintext.CSVItem;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.enums.HttpRequestMethod;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

class TcpAggregateRx
implements CSVItem {
    TcpAggregateRx() {
    }

    @Override
    public void write(ReportData data, BasicPrinter printer) throws IOException {
        HashMap<Port, RxTcpAggregation> rxAggregationMap = new HashMap<Port, RxTcpAggregation>();
        List<HttpFlowInstance> allTcps = data.tcpFlows();
        for (HttpFlowInstance http : allTcps) {
            HttpSession rxSession;
            HttpFlowInstanceReader httpFlowInstanceReader = EntityReaderFactory.create((HttpFlowInstance)http);
            if (!httpFlowInstanceReader.isConfigured() || (rxSession = http.getRequestMethod().equals((Object)HttpRequestMethod.GET) ? http.getClientHttpSession() : http.getServerHttpSession()) == null) continue;
            Port rxPort = rxSession.getHttpApplication().getPort();
            RxTcpAggregation rxAggregation = (RxTcpAggregation)rxAggregationMap.get(rxPort);
            if (rxAggregation == null) {
                rxAggregation = new RxTcpAggregation(rxPort);
                rxAggregationMap.put(rxPort, rxAggregation);
            }
            rxAggregation.add(rxSession);
        }
        boolean needsDocumentation = true;
        BasicPrinter.HeaderPrinter header = printer.headerPrinter();
        header.add("Port", "The name of the ByteBlower port where the measurements where taken.");
        header.add("Total Rx", "Bytes", "The total amount of received HTTP data on the port,");
        header.add("Alive duration", "ns", "The total time over which the TCP flows where alive,");
        header.add("Alive throuhput", "bit/s", "The throughput over the alive time,");
        header.add("Active duration", "ns", "The duration during which the tcp flows where active,");
        header.add("Active throughput", "bit/s", "The average throughput during the active time of the tcp flows.");
        for (Port port : rxAggregationMap.keySet()) {
            RxTcpAggregation tcpAggregation = (RxTcpAggregation)rxAggregationMap.get(port);
            if (!tcpAggregation.valid()) continue;
            if (needsDocumentation) {
                printer.title("Aggregate TCP Rx results");
                header.printDocumentation();
                header.printHeaders();
            }
            needsDocumentation = false;
            tcpAggregation.printOut(printer);
        }
    }

    private final class RxTcpAggregation {
        private List<HttpSession> httpSessions = new ArrayList<HttpSession>();
        private Port port;
        private boolean hasSessions;

        public RxTcpAggregation(Port port) {
            this.port = port;
            this.hasSessions = false;
        }

        public void add(HttpSession httpSession) {
            if (httpSession != null && httpSession.getRxFirstByteTime() != null) {
                this.httpSessions.add(httpSession);
                this.hasSessions = true;
            }
        }

        public boolean valid() {
            return this.hasSessions;
        }

        protected void printOut(BasicPrinter printer) throws IOException {
            Collections.sort(this.httpSessions, new Comparator<HttpSession>(){

                @Override
                public int compare(HttpSession lhs, HttpSession rhs) {
                    long lhsRxFirstByteTime = lhs.getRxFirstByteTime();
                    long rhsRxFirstByteTime = rhs.getRxFirstByteTime();
                    return Long.compare(lhsRxFirstByteTime, rhsRxFirstByteTime);
                }
            });
            Long smallestFirstByteTime = 0L;
            Long rxFirstByteTime = this.httpSessions.get(0).getRxFirstByteTime();
            if (rxFirstByteTime != null) {
                smallestFirstByteTime = rxFirstByteTime;
            }
            Long biggestLastByteTime = 0L;
            Long totalGapTime = 0L;
            Long totalRxBytes = 0L;
            for (HttpSession httpSession : this.httpSessions) {
                if (biggestLastByteTime != null && httpSession.getRxLastByteTime() != null && biggestLastByteTime == 0L) {
                    biggestLastByteTime = httpSession.getRxLastByteTime();
                } else {
                    if (httpSession.getRxFirstByteTime() != null && httpSession.getRxFirstByteTime() > biggestLastByteTime) {
                        totalGapTime = totalGapTime + (httpSession.getRxFirstByteTime() - biggestLastByteTime);
                    }
                    if (httpSession.getRxLastByteTime() != null && httpSession.getRxLastByteTime() > biggestLastByteTime) {
                        biggestLastByteTime = httpSession.getRxLastByteTime();
                    }
                }
                Long rxByteCount = httpSession.getRxByteCount();
                if (rxByteCount == null) continue;
                totalRxBytes = totalRxBytes + rxByteCount;
            }
            Long aliveDuration = 0L;
            if (biggestLastByteTime != null && smallestFirstByteTime != null) {
                aliveDuration = biggestLastByteTime - smallestFirstByteTime;
            }
            Long activeDuration = aliveDuration - totalGapTime;
            printer.printRecord(this.port.getName(), totalRxBytes, aliveDuration, this.calculateThroughput(aliveDuration, totalRxBytes), activeDuration, this.calculateThroughput(activeDuration, totalRxBytes));
        }

        private double calculateThroughput(long timeInNs, long totalNofBytesReceived) {
            double throughputBps = 0.0;
            long nanosToSeconds = 1000000000L;
            if (timeInNs > 0L && totalNofBytesReceived > 0L) {
                throughputBps = 8L * totalNofBytesReceived;
                throughputBps *= 1.0E9;
                throughputBps /= (double)timeInNs;
            }
            return throughputBps;
        }
    }
}

