/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.plaintext.BasicPrinter;
import com.excentis.products.byteblower.report.generator.plaintext.CSVItem;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpFlowInstanceReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

class TcpAggregateTx
implements CSVItem {
    TcpAggregateTx() {
    }

    @Override
    public void write(ReportData data, BasicPrinter printer) throws IOException {
        HashMap<Port, TxTcpAggregation> txAggregationMap = new HashMap<Port, TxTcpAggregation>();
        List<HttpFlowInstance> allTcps = data.tcpFlows();
        for (HttpFlowInstance http : allTcps) {
            HttpFlowInstanceReader reader = EntityReaderFactory.create((HttpFlowInstance)http);
            if (!reader.isConfigured()) continue;
            HttpSession txSession = reader.getSourceHttpSession();
            Port txPort = txSession.getHttpApplication().getPort();
            TxTcpAggregation txAggregation = (TxTcpAggregation)txAggregationMap.get(txPort);
            if (txAggregation == null) {
                txAggregation = new TxTcpAggregation(txPort);
                txAggregationMap.put(txPort, txAggregation);
            }
            txAggregation.add(txSession);
        }
        boolean needsDocumentation = true;
        BasicPrinter.HeaderPrinter header = printer.headerPrinter();
        header.add("Port", "The name of the ByteBlower port where the measurements where taken.");
        header.add("Total Tx", "Bytes", "The total amount of transmitted HTTP data on the port,");
        header.add("Alive duration", "ns", "The total time over which the TCP flows where alive,");
        header.add("Alive throuhput", "bit/s", "The throughput over the alive time,");
        header.add("Active duration", "ns", "The duration during which the tcp flows where active,");
        header.add("Active throughput", "bit/s", "The average throughput during the active time of the tcp flows.");
        for (Port port : txAggregationMap.keySet()) {
            TxTcpAggregation tcpAggregation = (TxTcpAggregation)txAggregationMap.get(port);
            if (!tcpAggregation.valid()) continue;
            if (needsDocumentation) {
                printer.title("Aggregate TCP Txresults");
                header.printDocumentation();
                header.printHeaders();
            }
            needsDocumentation = false;
            tcpAggregation.printOut(printer);
        }
    }

    private static final class TxTcpAggregation {
        private final List<HttpSession> httpSessions = new ArrayList<HttpSession>();
        private final Port port;
        private boolean hasSessions;

        public TxTcpAggregation(Port port) {
            this.port = port;
            this.hasSessions = false;
        }

        public void add(HttpSession httpSession) {
            if (httpSession != null && httpSession.getTxFirstByteTime() != null) {
                this.httpSessions.add(httpSession);
                this.hasSessions = true;
            }
        }

        public boolean valid() {
            return this.hasSessions;
        }

        protected void printOut(BasicPrinter printer) throws IOException {
            HttpSession session;
            Collections.sort(this.httpSessions, new Comparator<HttpSession>(){

                @Override
                public int compare(HttpSession lhs, HttpSession rhs) {
                    long lhsTxFirstByteTime = lhs.getTxFirstByteTime();
                    long rhsTxFirstByteTime = rhs.getTxFirstByteTime();
                    return Long.compare(lhsTxFirstByteTime, rhsTxFirstByteTime);
                }
            });
            long aggregateFirstTx = 0L;
            long aggregateLastTx = 0L;
            long gapTime = 0L;
            long totalTxBytes = this.sumTxbytes();
            Iterator<HttpSession> sessionIt = this.httpSessions.iterator();
            if (sessionIt.hasNext()) {
                session = sessionIt.next();
                aggregateFirstTx = session.getTxFirstByteTime();
                aggregateLastTx = session.getTxLastByteTime();
            }
            while (sessionIt.hasNext()) {
                session = sessionIt.next();
                long firstTx = session.getTxFirstByteTime();
                if (firstTx > aggregateLastTx) {
                    gapTime += firstTx - aggregateLastTx;
                }
                aggregateLastTx = Math.max(aggregateLastTx, session.getTxLastByteTime());
            }
            long aliveDuration = 0L;
            long activeDuration = 0L;
            if (totalTxBytes > 0L) {
                aliveDuration = aggregateLastTx - aggregateFirstTx;
                activeDuration = aliveDuration - gapTime;
            }
            printer.printRecord(this.port.getName(), totalTxBytes, aliveDuration, this.calculateThroughput(aliveDuration, totalTxBytes), activeDuration, this.calculateThroughput(activeDuration, totalTxBytes));
        }

        private long sumTxbytes() {
            long transmitted = 0L;
            for (HttpSession session : this.httpSessions) {
                Long txSession = session.getTxByteCount();
                if (txSession == null) continue;
                transmitted += txSession.longValue();
            }
            return transmitted;
        }

        private double calculateThroughput(long timeInNs, long totalNofBytesReceived) {
            double throughputBps = 0.0;
            long nanosToSeconds = 1000000000L;
            if (timeInNs > 0L && totalNofBytesReceived > 0L) {
                throughputBps = 8L * totalNofBytesReceived;
                throughputBps *= 1.0E9;
                throughputBps /= (double)timeInNs;
            }
            return throughputBps;
        }
    }
}

