/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.plaintext.BasicPrinter;
import com.excentis.products.byteblower.report.generator.plaintext.CSVItem;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit;
import java.io.IOException;
import java.util.List;

class TcpInfo
implements CSVItem {
    TcpInfo() {
    }

    @Override
    public void write(ReportData data, BasicPrinter printer) throws IOException {
        List<HttpFlowInstance> tcpFlows = data.tcpFlows();
        if (tcpFlows.isEmpty()) {
            return;
        }
        this.printHeader(printer);
        for (HttpFlowInstance httpFlow : tcpFlows) {
            this.printFlow(printer, httpFlow);
        }
    }

    private void printFlow(BasicPrinter printer, HttpFlowInstance httpFlow) throws IOException {
        HttpFlowInstanceReader httpFlowReader = EntityReaderFactory.create((HttpFlowInstance)httpFlow);
        String name = httpFlowReader.getName();
        String templateName = httpFlow.getFlowTemplate().getName();
        Long start = httpFlow.getStartTime();
        Long payload = httpFlow.getFlowTemplate().getHttpDataSize();
        Long duration = httpFlow.getDuration();
        Integer rxScale = httpFlow.getFlowTemplate().getRxWindowScaleValue();
        Integer rxWindowInitialValue = httpFlow.getFlowTemplate().getRxWindowInitialUnscaledSize();
        Double rateLimit = httpFlowReader.getRateLimit(DataRateUnit.BIT_PER_SECOND);
        String tos = httpFlowReader.getTos();
        printer.printRecord(name, templateName, start, payload, duration, rxScale, rxWindowInitialValue, rateLimit, tos);
    }

    private void printHeader(BasicPrinter printer) throws IOException {
        printer.title("TCP Info");
        BasicPrinter.HeaderPrinter header = printer.headerPrinter();
        header.add("Flow name", "The name of the flow.");
        header.add("Flow template", "The name of the configured flow template.");
        header.add("Start delay", "ns", "The configured start-delay of the flow.");
        header.add("Payload", "bytes", "The configured payload of the TCP flow. Is empty for duration based flows.");
        header.add("Duration", "ns", "The configured duration of the TCP flow. Is empty for payload based flows.");
        header.add("Initial Receive window", "bytes", "The intial size of the receive window.");
        header.add("Initial Receive Window Scale", "The scaling factor of the receive window. This value is textual. It lists first the exponent, then the multiplier. These denote the same value.");
        header.add("Rate Limit", "bit/s", "A configured rate limit. This field is empty on flows without rate limit.");
        header.add("TOS", "The value of the TOS byte.");
        header.printDocumentation();
        header.printHeaders();
    }
}

