/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.plaintext.BasicPrinter;
import com.excentis.products.byteblower.report.generator.plaintext.CSVItem;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.testdata.data.CumulativeSnapshotManager;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotRetransmissionCounters;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpSessionReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.PortReader;
import com.excentis.products.byteblower.results.testdata.data.enums.HttpRequestStatus;
import java.io.IOException;
import java.util.List;

class TcpRTTTable
implements CSVItem {
    TcpRTTTable() {
    }

    @Override
    public void write(ReportData data, BasicPrinter printer) throws IOException {
        CumulativeSnapshotManager cumul = new CumulativeSnapshotManager(data.testDataController());
        List<HttpFlowInstance> tcpFlows = data.tcpFlows();
        if (tcpFlows.isEmpty()) {
            return;
        }
        printer.title("TCP Roundtrip time table: ");
        BasicPrinter.HeaderPrinter header = printer.headerPrinter();
        header.add("Flow", "The name of the TCP flow");
        header.add("Source ", "The name of source the ByteBlower port.");
        header.add("Destination ", "The name of source the ByteBlower port.");
        header.add("Status", "The status of the TCP session");
        header.add("TTFB", "ns", "The time till the First Byte. This is a measure of the HTTP-session startup time.");
        header.add("Minimum RTT", "ns", "The minimal roundtrip time from source to destination of the TCP flow.");
        header.add("Average RTT", "ns", "The average roundtrip time from source to destination of the TCP flow.");
        header.add("Maximum RTT", "ns", "The maximal roundtrip time from source to destination of the TCP flow.");
        header.printDocumentation();
        header.printHeaders();
        for (HttpFlowInstance httpFlowInstance : tcpFlows) {
            Long timeToFirstByte;
            TcpSessionSnapshotRetransmissionCounters retransmit;
            TcpSessionSnapshot sourceCumul;
            HttpFlowInstanceReader flowInstanceReader = EntityReaderFactory.create((HttpFlowInstance)httpFlowInstance);
            if (!flowInstanceReader.isConfigured()) continue;
            HttpSession source = flowInstanceReader.getSourceHttpSession();
            TcpSession tcpSession = source != null ? source.getTcpSession() : null;
            if (tcpSession != null) {
                sourceCumul = cumul.find(tcpSession);
                retransmit = cumul.findRetransmissionCount(tcpSession);
            } else {
                sourceCumul = null;
                retransmit = null;
            }
            HttpFlowInstanceReader httpFlowReader = EntityReaderFactory.create((HttpFlowInstance)httpFlowInstance);
            HttpSession httpSourceSession = httpFlowReader.getSourceHttpSession();
            PortReader httpSourceReader = httpFlowReader.getSourceReader();
            HttpSession httpDestinationSession = httpFlowReader.getDestinationHttpSession();
            HttpSessionReader httpDestinationSessionReader = httpDestinationSession != null ? EntityReaderFactory.create((HttpSession)httpDestinationSession) : null;
            PortReader httpDestinationReader = httpFlowReader.getDestinationReader();
            String flowName = httpFlowReader.getName();
            String sourceName = httpSourceReader.getName();
            String destinationName = httpDestinationReader.getName();
            HttpFlowInstance instance = (HttpFlowInstance)httpFlowReader.getEntity();
            HttpRequestStatus status = instance.getRequestStatus();
            httpSourceSession.getTcpSession().getCongestionAvoidanceAlgorithm();
            long rttMax = Long.MAX_VALUE;
            long rttMin = Long.MIN_VALUE;
            long rttAvg = Long.MAX_VALUE;
            if (sourceCumul != null) {
                rttMax = sourceCumul.getRoundTripTimeMaximum();
                rttAvg = sourceCumul.getRoundTripTimeCurrent();
                rttMin = sourceCumul.getRoundTripTimeMinimum();
            }
            String strTimeToFirstByte = (timeToFirstByte = httpFlowReader.calculateTTFBNanoseconds(data.testDataController())) == null ? "N/A" : timeToFirstByte.toString();
            printer.printRecord(flowName, sourceName, destinationName, status, rttMin, rttMax, rttAvg, strTimeToFirstByte);
        }
    }
}

