/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.plaintext.BasicPrinter;
import com.excentis.products.byteblower.report.generator.plaintext.CSVItem;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotRetransmissionCounters;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotRxCounters;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotTxCounters;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpSessionReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.TcpSessionReader;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.io.IOException;
import java.util.List;

class TcpResultsOverTime
implements CSVItem {
    private boolean needsDoc = true;

    TcpResultsOverTime() {
    }

    @Override
    public void write(ReportData data, BasicPrinter printer) throws IOException {
        BasicPrinter.HeaderPrinter httpHeader = printer.headerPrinter();
        httpHeader.add("Flow", "The name of the TCP flow");
        httpHeader.add("Port", "The name of the ByteBlower port where the measurements where taken.");
        httpHeader.add("Time", "ns", "Timestamp of the snapshot. This timestamp is the start of the snapshot. It is based on unix time");
        httpHeader.add("Duration", "ns", "Duration of the snapshot.");
        httpHeader.add("Rx", "Bytes", "The amount of received data during the snapshot");
        httpHeader.add("Tx", "Bytes", "The amount of data transmitted data during the snapshot");
        BasicPrinter.HeaderPrinter tcpHeader = printer.headerPrinter();
        tcpHeader.add("Flow", "The name of the TCP flow");
        tcpHeader.add("Port", "The name of the ByteBlower port where the measurements where taken.");
        tcpHeader.add("Time", "ns", "Timestamp of the snapshot. This timestamp is the start of the snapshot. It is based on unix time");
        tcpHeader.add("Duration", "ns", "Duration of the snapshot.");
        tcpHeader.add("Current Congestion Window", "bytes", "The current value of the congestion window. This value is measured when at the end the snapshot interval.");
        tcpHeader.add("Maximum Congestion Window", "bytes", "The maximum value of the congestion window.");
        tcpHeader.add("Minimum Congestion Window", "bytes", "The minimum value of the congestion window.");
        tcpHeader.add("Current Receive Window", "bytes", "The current value of the receive window. This value is measured when at the end the snapshot interval.");
        tcpHeader.add("Maximum Receive Window", "bytes", "The maximum value of the receive window.");
        tcpHeader.add("Minimum Receive Window", "bytes", "The minimum value of the receive window.");
        tcpHeader.add("Average RTT", "ns", "The average roundtrip time of data packets from this ByteBlower port.");
        tcpHeader.add("Maximum RTT", "ns", "The maximum roundtrip time of data from this ByteBlower port.");
        tcpHeader.add("Minimum RTT", "ns", "The minimum roundtrip time of data from this ByteBlower port.");
        tcpHeader.add("Current SlowStart", "bytes", "The value of the slow-start threshold. This value is measured when at the end the snapshot interval.");
        tcpHeader.add("Remote ECN markings", "count", "The count of ECN markings as received by the remote side of the TCP connection. These markers are intended to throttle the outgoing traffic. See the ByteBlower API documentation for more info.");
        tcpHeader.add("Local ECN markings", "bytes", "The count of ECN markings for received TCP traffic. These markings are reflected. See the ByteBlower API documentation for more info.");
        tcpHeader.add("Rx headers", "bytes", "The data-size of the received TCP headers.");
        tcpHeader.add("Rx payload", "bytes", "The size of the received TCP payload.");
        tcpHeader.add("Rx total", "bytes", "The total amount of traffic at the TCP layer.");
        tcpHeader.add("Rx segments", "The number received TCP segments.");
        tcpHeader.add("Out of order segments", "The number TCP segments received out of order.");
        tcpHeader.add("Tx headers", "bytes", "The total size of the transmitted TCP headers during this snapshot.");
        tcpHeader.add("Tx payload", "bytes", "The size of the transmitted TCP payload.");
        tcpHeader.add("Tx total", "bytes", "The total amount of transmitted traffic at the TCP layer.");
        tcpHeader.add("Tx segments", "The number of transmitted TCP segments.");
        tcpHeader.add("Slow retransmissions", "The number of slow retransmissions during this snapshot by the ByteBlower port.");
        tcpHeader.add("Fast retransmissions", "The amount of fast retransmissions during in this snapshot");
        tcpHeader.add("Total retransmissions", "The total number of retransmissions in this snapshot.");
        List<HttpFlowInstance> tcpFlows = data.tcpFlows();
        for (HttpFlowInstance flowInstance : tcpFlows) {
            HttpSessionReader destinationSession;
            HttpFlowInstanceReader httpReader;
            if (flowInstance == null || (httpReader = EntityReaderFactory.create((HttpFlowInstance)flowInstance)) == null || !httpReader.isValid(flowInstance)) continue;
            HttpSessionReader sourceSession = httpReader.getSourceHttpSessionReader();
            if (sourceSession != null && httpReader.getSourceHttpSession().getTcpSession() != null) {
                this.printDocumentation(printer, httpHeader, tcpHeader);
                TcpSession tcpSessionSource = httpReader.getSourceHttpSession().getTcpSession();
                String flowName = httpReader.getName();
                EntityManager entityManager = data.entityManager();
                TcpSessionReader tcpSessionSourceReader = EntityReaderFactory.create((TcpSession)tcpSessionSource);
                TypedQuery httpQuery = sourceSession.getSnapshotsQuery(entityManager);
                TypedQuery tcpSourceQuery = tcpSessionSourceReader.getSnapshotsQuery(entityManager);
                String portName = httpReader.getSourceReader().getName();
                this.httpResults(printer, httpReader, flowName, portName, (TypedQuery<HttpSessionSnapshot>)httpQuery, httpHeader);
                this.tcpResults(printer, httpReader, flowName, portName, (TypedQuery<TcpSessionSnapshot>)tcpSourceQuery, tcpHeader);
                entityManager.close();
            }
            if ((destinationSession = httpReader.getDestinationHttpSessionReader()) == null || httpReader.getDestinationHttpSession().getTcpSession() == null) continue;
            this.printDocumentation(printer, httpHeader, tcpHeader);
            TcpSession tcpSession = httpReader.getDestinationHttpSession().getTcpSession();
            String flowName = httpReader.getName();
            EntityManager entityManager = data.entityManager();
            TcpSessionReader tcpSessionReader = EntityReaderFactory.create((TcpSession)tcpSession);
            TypedQuery httpQuery = destinationSession.getSnapshotsQuery(entityManager);
            TypedQuery tcpQuery = tcpSessionReader.getSnapshotsQuery(entityManager);
            String portName = httpReader.getDestinationReader().getName();
            this.httpResults(printer, httpReader, flowName, portName, (TypedQuery<HttpSessionSnapshot>)httpQuery, httpHeader);
            this.tcpResults(printer, httpReader, flowName, portName, (TypedQuery<TcpSessionSnapshot>)tcpQuery, tcpHeader);
            entityManager.close();
        }
    }

    private void printDocumentation(BasicPrinter printer, BasicPrinter.HeaderPrinter httpHeader, BasicPrinter.HeaderPrinter tcpHeader) throws IOException {
        if (this.needsDoc) {
            printer.title("HTTP and TCP results over time");
            httpHeader.printDocumentation();
            tcpHeader.printDocumentation();
        }
        this.needsDoc = false;
    }

    private void httpResults(BasicPrinter printer, HttpFlowInstanceReader httpReader, String flowName, String portName, TypedQuery<HttpSessionSnapshot> httpQuery, BasicPrinter.HeaderPrinter httpHeader) throws IOException {
        String srcPort = httpReader.getSourceReader().getName();
        String dstPort = httpReader.getDestinationReader().getName();
        printer.title("Http results over time");
        printer.printComment("Flow name: " + flowName);
        printer.printComment("Source port: " + srcPort);
        printer.printComment("Destination port: " + dstPort);
        httpHeader.printHeaders();
        httpQuery.setHint("jakarta.persistence.cache.storeMode", (Object)CacheStoreMode.BYPASS);
        httpQuery.setHint("eclipselink.maintain-cache", (Object)"False");
        for (HttpSessionSnapshot httpSnap : httpQuery.getResultList()) {
            Long snapshotTime = httpSnap.getSnapshotTime();
            Long snapDuration = httpSnap.getSnapshotDuration();
            Long rxBytes = httpSnap.getRxByteCount();
            Long txBytes = httpSnap.getTxByteCount();
            printer.printRecord(flowName, portName, snapshotTime, snapDuration, rxBytes, txBytes);
        }
        printer.println();
    }

    private void tcpResults(BasicPrinter printer, HttpFlowInstanceReader httpReader, String flowName, String portName, TypedQuery<TcpSessionSnapshot> tcpQuery, BasicPrinter.HeaderPrinter tcpHeader) throws IOException {
        printer.title("Tcp results over time");
        String srcPort = httpReader.getSourceReader().getName();
        String dstPort = httpReader.getDestinationReader().getName();
        printer.printComment("Flow name: " + flowName);
        printer.printComment("Source port: " + srcPort);
        printer.printComment("Destination port: " + dstPort);
        tcpHeader.printHeaders();
        tcpQuery.setHint("jakarta.persistence.cache.storeMode", (Object)CacheStoreMode.BYPASS);
        tcpQuery.setHint("eclipselink.maintain-cache", (Object)"False");
        for (TcpSessionSnapshot tcpSnap : tcpQuery.getResultList()) {
            long snapshotTime = tcpSnap.getSnapshotTime();
            long snapshotDuration = tcpSnap.getSnapshotDuration();
            long congestionCurrent = tcpSnap.getCongestionWindowCurrent();
            long congestionMaximum = tcpSnap.getCongestionWindowMaximum();
            long congestionMinimum = tcpSnap.getCongestionWindowMinimum();
            long receiverCurrent = tcpSnap.getReceiverWindowCurrent();
            long receiverMaximum = tcpSnap.getReceiverWindowMaximum();
            long receiverMinimum = tcpSnap.getReceiverWindowMinimum();
            long rttCurrent = tcpSnap.getRoundTripTimeCurrent();
            long rttMaximum = tcpSnap.getRoundTripTimeMaximum();
            long rttMinimum = tcpSnap.getRoundTripTimeMinimum();
            long slowStartCurrent = tcpSnap.getSlowStartThresholdCurrent();
            long remoteECNMarkings = tcpSnap.getRemoteECNMarkings();
            long localECNMarkings = tcpSnap.getLocalECNMarkings();
            long rxHeaders = 0L;
            long rxPayload = 0L;
            long rxTotal = 0L;
            long rxSegmentCount = 0L;
            long rxSegmentOO = 0L;
            TcpSessionSnapshotRxCounters rxCounters = tcpSnap.getRxCounters();
            if (rxCounters != null) {
                rxHeaders = rxCounters.getBytesHeader();
                rxPayload = rxCounters.getBytesPayload();
                rxTotal = rxCounters.getBytesTotal();
                rxSegmentCount = rxCounters.getSegmentCount();
                rxSegmentOO = rxCounters.getSegmentsOutofOrder();
            }
            TcpSessionSnapshotTxCounters txCounters = tcpSnap.getTxCounters();
            long txHeader = 0L;
            long txPayload = 0L;
            long txTotal = 0L;
            long txSegments = 0L;
            if (txCounters != null) {
                txHeader = txCounters.getBytesHeader();
                txPayload = txCounters.getBytesPayload();
                txTotal = txCounters.getBytesTotal();
                txSegments = txCounters.getSegmentCount();
            }
            TcpSessionSnapshotRetransmissionCounters retransmissions = tcpSnap.getRetransmissions();
            long totalRetrans = 0L;
            long fastRetrans = 0L;
            long slowRetrans = 0L;
            if (retransmissions != null) {
                totalRetrans = retransmissions.getTotalRetransmissions();
                fastRetrans = retransmissions.getFastRetransmissions();
                slowRetrans = retransmissions.getSlowRetransmissions();
            }
            printer.printRecord(flowName, portName, snapshotTime, snapshotDuration, congestionCurrent, congestionMaximum, congestionMinimum, receiverCurrent, receiverMaximum, receiverMinimum, rttCurrent, rttMaximum, rttMinimum, slowStartCurrent, remoteECNMarkings, localECNMarkings, rxHeaders, rxPayload, rxTotal, rxSegmentCount, rxSegmentOO, txHeader, txPayload, txTotal, txSegments, slowRetrans, fastRetrans, totalRetrans);
        }
        printer.println();
    }
}

