/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext;

import com.excentis.products.byteblower.report.generator.plaintext.BasicPrinter;
import com.excentis.products.byteblower.report.generator.plaintext.CSVItem;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.testdata.data.CumulativeSnapshotManager;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotRetransmissionCounters;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpSessionReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.PortReader;
import com.excentis.products.byteblower.results.testdata.data.enums.HttpRequestStatus;
import com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit;
import java.io.IOException;
import java.util.List;

class TcpTable
implements CSVItem {
    TcpTable() {
    }

    @Override
    public void write(ReportData data, BasicPrinter printer) throws IOException {
        CumulativeSnapshotManager cumul = new CumulativeSnapshotManager(data.testDataController());
        List<HttpFlowInstance> tcpFlows = data.tcpFlows();
        if (tcpFlows.isEmpty()) {
            return;
        }
        printer.title("TCP results table");
        BasicPrinter.HeaderPrinter header = printer.headerPrinter();
        header.add("Flow", "The name of the TCP flow");
        header.add("Source ", "The name of source the ByteBlower port.");
        header.add("Destination ", "The name of source the ByteBlower port.");
        header.add("TX data", "Bytes", "The total amount of received HTTP data.");
        header.add("Rx data", "Bytes", "The total amount of transmitted HTTP data.");
        header.add("Tx duration", "ns", "The alive time of the HTTP flow at the destination port.");
        header.add("Rx duration", "ns", "The alive time of the HTTP flow at the source port.");
        header.add("Throughput", "bit/s", "The average throughput of the HTTP flow.");
        header.add("Status", "The status of the TCP session");
        header.add("Retransmissions", "A count of the number of retransmissions.");
        header.add("Minimum RTT", "ns", "The minimal roundtrip time from source to destination of the TCP flow.");
        header.add("Maximum RTT", "ns", "The maximal roundtrip time from source to destination of the TCP flow.");
        header.add("Average RTT", "ns", "The average roundtrip time from source to destination of the TCP flow.");
        header.add("TTFB", "ns", "The time till the First Byte. This is a measure of the HTTP-session startup time.");
        header.printDocumentation();
        header.printHeaders();
        for (HttpFlowInstance httpFlowInstance : tcpFlows) {
            Long timeToFirstByte;
            TcpSessionSnapshotRetransmissionCounters retransmit;
            TcpSessionSnapshot sourceCumul;
            HttpFlowInstanceReader flowInstanceReader = EntityReaderFactory.create((HttpFlowInstance)httpFlowInstance);
            if (!flowInstanceReader.isConfigured()) continue;
            HttpSession source = flowInstanceReader.getSourceHttpSession();
            TcpSession tcpSession = source != null ? source.getTcpSession() : null;
            if (tcpSession != null) {
                sourceCumul = cumul.find(tcpSession);
                retransmit = cumul.findRetransmissionCount(tcpSession);
            } else {
                sourceCumul = null;
                retransmit = null;
            }
            HttpFlowInstanceReader httpFlowReader = EntityReaderFactory.create((HttpFlowInstance)httpFlowInstance);
            HttpSession httpSourceSession = httpFlowReader.getSourceHttpSession();
            PortReader httpSourceReader = httpFlowReader.getSourceReader();
            HttpSession httpDestinationSession = httpFlowReader.getDestinationHttpSession();
            HttpSessionReader httpDestinationSessionReader = httpDestinationSession != null ? EntityReaderFactory.create((HttpSession)httpDestinationSession) : null;
            PortReader httpDestinationReader = httpFlowReader.getDestinationReader();
            String flowName = httpFlowReader.getName();
            String sourceName = httpSourceReader.getName();
            String destinationName = httpDestinationReader.getName();
            Long txBytes = httpSourceSession.getTxByteCount();
            Long rxBytes = httpDestinationSession.getRxByteCount();
            Long rxDuration = httpDestinationSessionReader.getRxDurationNanoseconds();
            Long txDuration = httpDestinationSessionReader.getTxDurationNanoseconds();
            Double avgRx = httpDestinationSessionReader.getRxThroughput(DataRateUnit.BIT_PER_SECOND);
            if (avgRx == null && httpSourceSession != null) {
                HttpSessionReader sourceReader = EntityReaderFactory.create((HttpSession)httpSourceSession);
                avgRx = sourceReader.getTxThroughput(DataRateUnit.BIT_PER_SECOND);
            }
            HttpFlowInstance instance = (HttpFlowInstance)httpFlowReader.getEntity();
            HttpRequestStatus status = instance.getRequestStatus();
            httpSourceSession.getTcpSession().getCongestionAvoidanceAlgorithm();
            long totalRetransmit = 0L;
            if (retransmit != null) {
                totalRetransmit = retransmit.getTotalRetransmissions();
            }
            long rttMax = Long.MAX_VALUE;
            long rttMin = Long.MIN_VALUE;
            long rttAvg = Long.MAX_VALUE;
            if (sourceCumul != null) {
                rttMax = sourceCumul.getRoundTripTimeMaximum();
                rttAvg = sourceCumul.getRoundTripTimeCurrent();
                rttMin = sourceCumul.getRoundTripTimeMinimum();
            }
            String strTimeToFirstByte = (timeToFirstByte = httpFlowReader.calculateTTFBNanoseconds(data.testDataController())) == null ? "N/A" : timeToFirstByte.toString();
            printer.printRecord(flowName, sourceName, destinationName, txBytes, rxBytes, txDuration, rxDuration, avgRx, status, totalRetransmit, rttMin, rttMax, rttAvg, strTimeToFirstByte);
        }
    }
}

