/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext.json;

import com.excentis.products.byteblower.report.generator.core.parameters.ParameterConvertor;
import com.excentis.products.byteblower.report.generator.core.parameters.ThroughputTypeParameter;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowTemplate;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowTemplateFrame;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFrameSizeFixed;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowTemplateReader;
import com.excentis.products.byteblower.results.testdata.data.utils.EthernetThroughputType;
import java.util.ArrayList;
import java.util.List;

class FBFlowConfig {
    String name;
    String flowTemplate;
    long startDelay;
    long duration;
    long packetInterval;
    long packets;
    List<Integer> packetSizes;
    String packetSizesInfo;
    Double intendedLoad;
    String tos;

    FBFlowConfig(FbFlowInstance dbFlow, ReportData data) {
        FbFlowTemplate template = dbFlow.getFlowTemplate();
        this.name = dbFlow.getFlow().getName();
        this.flowTemplate = template.getName();
        this.startDelay = dbFlow.getStartTime();
        this.duration = dbFlow.getDuration();
        this.packets = dbFlow.getFrameCount();
        this.packetInterval = template.getFrameInterval();
        this.packetSizes = new ArrayList<Integer>();
        for (FbFlowTemplateFrame frame : template.getFrames()) {
            int ctr = 0;
            while (ctr < frame.getRepeatCount()) {
                if (frame.getFrame() instanceof FbFrameSizeFixed) {
                    FbFrameSizeFixed fixedSize = (FbFrameSizeFixed)frame.getFrame();
                    this.packetSizes.add(fixedSize.getSize());
                }
                ++ctr;
            }
        }
        this.packetSizesInfo = this.getPacketSizesString();
        FbFlowTemplateReader reader = EntityReaderFactory.create((FbFlowTemplate)template);
        EthernetThroughputType etherType = ParameterConvertor.convertThroughputType((ThroughputTypeParameter)data.getThroughputType());
        this.intendedLoad = reader.getThroughput(etherType);
        FbFlowInstanceReader flowReader = EntityReaderFactory.create((FbFlowInstance)dbFlow);
        this.tos = flowReader.getTos();
    }

    public String getPacketSizesString() {
        if (this.packetSizes.isEmpty()) {
            return "Mixed";
        }
        ArrayList<String> strSizes = new ArrayList<String>();
        for (Integer size : this.packetSizes) {
            strSizes.add(size.toString());
        }
        String result = String.join((CharSequence)" | ", strSizes);
        return result;
    }
}

