/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext.json;

import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.report.generator.plaintext.json.LatencyTrigger;
import com.excentis.products.byteblower.report.generator.plaintext.json.OutOfSequenceTrigger;
import com.excentis.products.byteblower.report.generator.plaintext.json.SizeEstimation;
import com.excentis.products.byteblower.report.generator.plaintext.json.Trigger;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;

class JsonDestination
implements SizeEstimation {
    String name;
    Trigger received;
    LatencyTrigger latency;
    OutOfSequenceTrigger outOfSequence;

    JsonDestination(FbDestination destination, ReportData data) {
        this(destination, data, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public JsonDestination(FbDestination destination, ReportData data, long start, long end) {
        this.name = destination.getPort().getName();
        if (destination.getTrigger() != null) {
            this.received = new Trigger(destination.getTrigger(), data, start, end);
        }
        if (destination.getLatency() != null) {
            this.latency = new LatencyTrigger(destination.getLatency(), data, start, end);
        }
        if (destination.getOutOfSequence() != null) {
            this.outOfSequence = new OutOfSequenceTrigger(destination.getOutOfSequence(), data, start, end);
        }
    }

    @Override
    public long approxByteSize() {
        long everyTrigger = 3L;
        return 100L + 3L * this.received.approxByteSize();
    }
}

