/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext.json;

import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.report.generator.plaintext.json.ISO8601;
import com.excentis.products.byteblower.results.testdata.data.EventManager;
import com.excentis.products.byteblower.results.testdata.data.entities.Event;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstanceEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.NatAddressMappingEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.PortEvent;
import com.excentis.products.byteblower.results.testdata.data.entities.ServerEvent;
import com.excentis.products.byteblower.results.testdata.data.enums.EventSeverity;
import java.util.ArrayList;
import java.util.List;

public class JsonEvent {
    String name;
    String time;
    String severity;
    String description;
    String knowledgeBaseLink;

    public static List<JsonEvent> events(ReportData data) {
        ArrayList<JsonEvent> events = new ArrayList<JsonEvent>();
        EventManager ev = new EventManager(data.testDataController());
        for (Event event : ev.getEntities()) {
            if (event.getSeverity() == EventSeverity.TEST_LOG) continue;
            String name = JsonEvent.getEventObjectName(event);
            String severity = event.getSeverity().name();
            String description = event.getDescription();
            String eventTime = ISO8601.toString(event.getEventTime());
            String knowledgeBaseLink = event.getKnowledgebaseLink();
            JsonEvent jsonEvent = new JsonEvent(name, eventTime, severity, description, knowledgeBaseLink);
            events.add(jsonEvent);
        }
        return events;
    }

    public static String getEventObjectName(Event event) {
        if (event instanceof PortEvent) {
            PortEvent p = (PortEvent)event;
            Port port = p.getPort();
            return port != null ? port.getName() : "";
        }
        if (event instanceof FlowInstanceEvent) {
            FlowInstanceEvent flow = (FlowInstanceEvent)event;
            return flow.getFlowInstance().getFlow().getName();
        }
        if (event instanceof ServerEvent) {
            ServerEvent server = (ServerEvent)event;
            return server.getServer().getUrl();
        }
        if (event instanceof NatAddressMappingEvent) {
            NatAddressMappingEvent nat = (NatAddressMappingEvent)event;
            return nat.getAddressMapping().getResolverPort().getName();
        }
        return "";
    }

    public JsonEvent(String name, String time, String severity, String description, String knowledgeBaseLink) {
        this.name = name;
        this.time = time;
        this.severity = severity;
        this.description = description;
        this.knowledgeBaseLink = knowledgeBaseLink;
    }

    public String getName() {
        return this.name;
    }

    public String getTime() {
        return this.time;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getDescription() {
        return this.description;
    }

    public String getKnowledgeBaseLink() {
        return this.knowledgeBaseLink;
    }
}

