/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext.json;

import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.report.generator.plaintext.json.FBFlowConfig;
import com.excentis.products.byteblower.report.generator.plaintext.json.JsonDestination;
import com.excentis.products.byteblower.report.generator.plaintext.json.JsonSource;
import com.excentis.products.byteblower.report.generator.plaintext.json.SizeEstimation;
import com.excentis.products.byteblower.report.generator.plaintext.json.TimeRange;
import com.excentis.products.byteblower.results.testdata.data.BaseEntityManager;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import java.util.ArrayList;
import java.util.List;

class JsonFbFlow
implements SizeEstimation {
    protected FBFlowConfig config;
    protected List<JsonDestination> destinations;
    protected JsonSource source;

    private JsonFbFlow(FbFlowInstance dbFlow, ReportData data) {
        this(dbFlow, data, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public JsonFbFlow(FbFlowInstance dbFlow, ReportData data, long start, long end) {
        this.source = new JsonSource(dbFlow.getSource(), data, start, end);
        this.destinations = new ArrayList<JsonDestination>();
        this.config = new FBFlowConfig(dbFlow, data);
        FbFlowInstanceReader reader = EntityReaderFactory.create((FbFlowInstance)dbFlow);
        for (FbDestination destination : reader.getDestinations()) {
            this.destinations.add(new JsonDestination(destination, data, start, end));
        }
    }

    static List<JsonFbFlow> flows(ReportData data) {
        ArrayList<JsonFbFlow> flows = new ArrayList<JsonFbFlow>();
        BaseEntityManager portManager = new BaseEntityManager(FbFlowInstance.class, data.testDataController());
        data.testDataController().getEntityManager().clear();
        for (FbFlowInstance p : portManager.getEntities()) {
            flows.add(new JsonFbFlow(p, data));
        }
        return flows;
    }

    public static List<JsonFbFlow> flows(ReportData data, long start, long end) {
        ArrayList<JsonFbFlow> flows = new ArrayList<JsonFbFlow>();
        BaseEntityManager portManager = new BaseEntityManager(FbFlowInstance.class, data.testDataController());
        data.testDataController().getEntityManager().clear();
        for (FbFlowInstance p : portManager.getEntities()) {
            flows.add(new JsonFbFlow(p, data, start, end));
        }
        return flows;
    }

    public TimeRange getRange() {
        TimeRange range = new TimeRange();
        if (this.source.sent != null) {
            range = range.merge(this.source.sent.getRange());
        }
        for (JsonDestination dest : this.destinations) {
            range = range.merge(dest.received.getRange());
        }
        return range;
    }

    @Override
    public long approxByteSize() {
        long approx = 200L;
        approx += this.source.approxByteSize();
        for (JsonDestination dest : this.destinations) {
            approx += dest.approxByteSize();
        }
        return approx;
    }
}

