/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext.json;

import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.report.generator.plaintext.json.ISO8601;
import com.excentis.products.byteblower.report.generator.plaintext.json.JsonHTTPSnapshot;
import com.excentis.products.byteblower.report.generator.plaintext.json.LazyQuery;
import com.excentis.products.byteblower.report.generator.plaintext.json.SizeEstimation;
import com.excentis.products.byteblower.report.generator.plaintext.json.TimeRange;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collection;

class JsonHTTPSessionEnd
implements SizeEstimation {
    String portName;
    long rxBytes;
    long txBytes;
    String rxFirst;
    String rxLast;
    String txFirst;
    String txLast;
    Collection<JsonHTTPSnapshot> overTimeResults = new ArrayList<JsonHTTPSnapshot>();

    public JsonHTTPSessionEnd(HttpSession httpSession, ReportData data, long start, long end) {
        this.portName = httpSession.getHttpApplication().getPort().getName();
        if (httpSession.getRxByteCount() != null) {
            this.rxBytes = httpSession.getRxByteCount();
        }
        if (httpSession.getTxByteCount() != null) {
            this.txBytes = httpSession.getTxByteCount();
        }
        if (this.rxBytes > 0L) {
            this.rxFirst = ISO8601.instantString(httpSession.getRxFirstByteTime());
            this.rxLast = ISO8601.instantString(httpSession.getRxLastByteTime());
        }
        if (this.txBytes > 0L) {
            this.txFirst = ISO8601.instantString(httpSession.getTxFirstByteTime());
            this.txLast = ISO8601.instantString(httpSession.getTxLastByteTime());
        }
        if (!httpSession.isDockedMobile()) {
            EntityManager mgr = data.testDataController().getEntityManager();
            TypedQuery snapshots = EntityReaderFactory.create((HttpSession)httpSession).getSnapshotsQuery(mgr, start, end);
            this.overTimeResults = new LazyQuery<HttpSessionSnapshot, JsonHTTPSnapshot>(snapshots, JsonHTTPSnapshot::new);
        }
    }

    public TimeRange getRange() {
        TimeRange result = new TimeRange();
        for (JsonHTTPSnapshot snap : this.overTimeResults) {
            TimeRange snapTime = new TimeRange(snap.iTimestamp, snap.iTimestamp + snap.duration);
            result = result.merge(snapTime);
        }
        return result;
    }

    @Override
    public long approxByteSize() {
        return 500L + 1000L * (long)(this.overTimeResults == null ? 0 : this.overTimeResults.size());
    }
}

