/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext.json;

import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.report.generator.plaintext.json.JsonHTTPSessionEnd;
import com.excentis.products.byteblower.report.generator.plaintext.json.JsonTcpSessionEnd;
import com.excentis.products.byteblower.report.generator.plaintext.json.SizeEstimation;
import com.excentis.products.byteblower.report.generator.plaintext.json.TimeRange;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowTemplate;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpFlowInstanceReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class JsonHttpFlow
implements SizeEstimation {
    String name;
    String flowTemplate;
    long startDelay;
    long duration;
    long size;
    String method;
    long ratelimit;
    String state;
    Long timeToFirstByte;
    Integer configuredTos;
    boolean l4sEnabled;
    JsonHTTPSessionEnd httpClient;
    JsonHTTPSessionEnd httpServer;
    JsonTcpSessionEnd tcpClient;
    JsonTcpSessionEnd tcpServer;

    public static List<JsonHttpFlow> flows(ReportData data, long start, long end) {
        data.testDataController().getEntityManager().clear();
        ArrayList<JsonHttpFlow> flows = new ArrayList<JsonHttpFlow>();
        for (HttpFlowInstance aFlow : data.tcpFlows()) {
            flows.add(new JsonHttpFlow(aFlow, data, start, end));
        }
        return flows;
    }

    public JsonHttpFlow(HttpFlowInstance flow, ReportData data, long start, long end) {
        this.method = flow.getRequestMethod().toString();
        if (flow.getFlowTemplate().getRateLimitation() != null) {
            this.ratelimit = flow.getFlowTemplate().getRateLimitation();
        }
        HttpFlowTemplate template = flow.getFlowTemplate();
        this.flowTemplate = template.getName();
        this.startDelay = flow.getStartTime();
        if (flow.getDuration() != null) {
            this.duration = flow.getDuration();
        } else {
            this.size = template.getHttpDataSize();
        }
        this.state = flow.getRequestStatusString();
        this.httpClient = new JsonHTTPSessionEnd(flow.getClientHttpSession(), data, start, end);
        this.httpServer = new JsonHTTPSessionEnd(flow.getServerHttpSession(), data, start, end);
        if (!flow.getClientHttpSession().isDockedMobile()) {
            this.tcpClient = new JsonTcpSessionEnd(flow, flow.getClientHttpSession(), data.testDataController(), start, end);
        }
        this.tcpServer = new JsonTcpSessionEnd(flow, flow.getServerHttpSession(), data.testDataController(), start, end);
        this.name = flow.getFlow().getName();
        HttpFlowInstanceReader httpFlowReader = EntityReaderFactory.create((HttpFlowInstance)flow);
        this.timeToFirstByte = httpFlowReader.calculateTTFBNanoseconds(data.testDataController());
        String hexTos = httpFlowReader.getTos();
        this.configuredTos = 0;
        try {
            if (hexTos != null) {
                String shorter = hexTos.replace("0x", "");
                this.configuredTos = Integer.parseInt(shorter, 16);
            }
        }
        catch (NumberFormatException e) {
            Logger.getGlobal().warning("Unable to save TOS value");
        }
        this.l4sEnabled = template.getIsL4sEnabled();
    }

    public TimeRange getRange() {
        TimeRange result = new TimeRange();
        return result.merge(this.httpClient != null ? this.httpClient.getRange() : new TimeRange()).merge(this.httpServer != null ? this.httpServer.getRange() : new TimeRange()).merge(this.tcpClient != null ? this.tcpClient.getRange() : new TimeRange()).merge(this.tcpServer != null ? this.tcpServer.getRange() : new TimeRange());
    }

    @Override
    public long approxByteSize() {
        long approxServer = 2L * (this.httpServer == null ? 0L : this.httpServer.approxByteSize());
        long approxClient = 2L * (this.httpServer == null ? 0L : this.httpServer.approxByteSize());
        return 1500L + approxServer + approxClient;
    }
}

