/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext.json;

import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.report.generator.plaintext.json.JsonByteBlowerPort;
import com.excentis.products.byteblower.report.generator.plaintext.json.NatDiscovery;
import com.excentis.products.byteblower.results.testdata.data.BaseEntityManager;
import com.excentis.products.byteblower.results.testdata.data.NatAddressMappingManager;
import com.excentis.products.byteblower.results.testdata.data.NatPortMappingManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.Ipv4NatConfiguration;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4;
import com.excentis.products.byteblower.results.testdata.data.entities.NatAddressMapping;
import com.excentis.products.byteblower.results.testdata.data.entities.NatPortMapping;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.PortReader;
import com.excentis.products.byteblower.results.testdata.data.utils.Ipv4AddressUtility;
import java.util.ArrayList;
import java.util.List;

public class JsonIpv4Port
extends JsonByteBlowerPort {
    private String ipAddress;
    private String gateway;
    private String netmask;
    private String nat;
    private List<NatDiscovery> natDiscoveries;

    public static List<JsonIpv4Port> ports(ReportData data) {
        ArrayList<JsonIpv4Port> ports = new ArrayList<JsonIpv4Port>();
        BaseEntityManager portManager = new BaseEntityManager(Port.class, data.testDataController());
        for (Port port : portManager.getEntities()) {
            PortReader portRead = EntityReaderFactory.create((Port)port);
            if (!portRead.isIPv4()) continue;
            ports.add(new JsonIpv4Port(port, data));
        }
        ports.sort((a, b) -> a.name.compareTo(b.name));
        return ports;
    }

    public JsonIpv4Port(Port dbPort, ReportData data) {
        super(dbPort, data);
        Layer3Ipv4 layer3Ipv4;
        Ipv4NatConfiguration natConfiguration;
        PortReader portReader = EntityReaderFactory.create((Port)dbPort);
        this.ipAddress = portReader.getIPv4Address();
        this.gateway = portReader.getIPv4Gateway();
        this.netmask = portReader.getIpv4Netmask();
        this.nat = portReader.getNat();
        this.natDiscoveries = new ArrayList<NatDiscovery>();
        Layer3 layer3 = dbPort.getLayer3();
        TestDataPersistenceController control = data.testDataController();
        NatAddressMappingManager addressMapManager = new NatAddressMappingManager(control);
        NatPortMappingManager portMapManager = new NatPortMappingManager(control);
        if (layer3 instanceof Layer3Ipv4 && (natConfiguration = (layer3Ipv4 = (Layer3Ipv4)layer3).getNatConfiguration()) != null) {
            List addressMappings = addressMapManager.find(data.scenario(), dbPort);
            for (NatAddressMapping addressMapping : addressMappings) {
                this.pushMappings(portReader, portMapManager, addressMapping);
            }
        }
    }

    private void pushMappings(PortReader portReader, NatPortMappingManager portMapManager, NatAddressMapping addressMapping) {
        String portPrivate = addressMapping.getTargetPort().getName();
        String portPublic = addressMapping.getResolverPort().getName();
        String privateIp = portReader.getIPv4Address();
        String publicIp = Ipv4AddressUtility.convertToString((byte[])addressMapping.getPublicAddress().getAddress());
        String ipDiscoveryMethod = addressMapping.getMethod();
        for (NatPortMapping portMapping : portMapManager.findAll(addressMapping)) {
            String protocol = portMapping.getProtocol().name();
            int privatePort = portMapping.getPrivatePort();
            String portDiscoveryMethod = portMapping.getMethod();
            int publicPort = portMapping.getPublicPort();
            NatDiscovery nat = new NatDiscovery(portPrivate, portPublic, privateIp, publicIp, ipDiscoveryMethod, protocol, privatePort, publicPort, portDiscoveryMethod);
            this.natDiscoveries.add(nat);
        }
    }
}

