/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext.json;

import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.report.generator.plaintext.json.JsonByteBlowerPort;
import com.excentis.products.byteblower.results.testdata.data.BaseEntityManager;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.PortReader;
import java.util.ArrayList;
import java.util.List;

public class JsonIpv6Port
extends JsonByteBlowerPort {
    private String linkLocalAddress;
    private List<String> ipAddresses;
    private List<Integer> prefixLengths;
    private List<String> routers;

    public static List<JsonIpv6Port> ports(ReportData data) {
        ArrayList<JsonIpv6Port> ports = new ArrayList<JsonIpv6Port>();
        BaseEntityManager portManager = new BaseEntityManager(Port.class, data.testDataController());
        for (Port port : portManager.getEntities()) {
            PortReader portRead = EntityReaderFactory.create((Port)port);
            if (!portRead.isIPv6()) continue;
            ports.add(new JsonIpv6Port(port, data));
        }
        ports.sort((a, b) -> a.name.compareTo(b.name));
        return ports;
    }

    public JsonIpv6Port(Port dbPort, ReportData data) {
        super(dbPort, data);
        PortReader portReader = EntityReaderFactory.create((Port)dbPort);
        this.linkLocalAddress = portReader.getLinkLocalAddress();
        this.ipAddresses = portReader.getIPv6Addresses();
        this.routers = portReader.getIPv6Gateways();
        this.prefixLengths = portReader.getIPv6PrefixLengths();
    }
}

