/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext.json;

import com.excentis.products.byteblower.report.data.entities.core.ReportOutputFormat;
import com.excentis.products.byteblower.report.data.entities.templates.ReportTemplateEntity;
import com.excentis.products.byteblower.report.generator.core.AbstractReportManager;
import com.excentis.products.byteblower.report.generator.core.GenerateReportListener;
import com.excentis.products.byteblower.report.generator.core.ReportPreferencesInterface;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.report.generator.plaintext.json.JsonScenario;
import com.excentis.products.byteblower.report.generator.plaintext.json.TimeRange;
import com.excentis.products.byteblower.results.dataprovider.data.entities.ReportGeneration;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;

public class JsonReportManager
extends AbstractReportManager {
    private static Logger LOGGER = Logger.getGlobal();
    private String filename = null;

    static {
        assert (JsonReportManager.steps(new TimeRange(0L, 0L), 0L).count() == 1L);
        assert (JsonReportManager.steps(new TimeRange(0L, 0L), 1L).count() == 1L);
        assert (JsonReportManager.steps((TimeRange)new TimeRange((long)0L, (long)0L), (long)1L).findFirst().get().start == 0L);
        Supplier<Stream> genManySteps = () -> JsonReportManager.steps(new TimeRange(0L, Long.MAX_VALUE), 0L).limit(20L);
        assert (genManySteps.get().count() > 10L);
        assert (genManySteps.get().map(r -> r.start).distinct().count() > 10L);
        assert (genManySteps.get().map(r -> r.end).distinct().count() > 10L);
        assert (genManySteps.get().filter(r -> r.start == r.end).count() == 0L);
    }

    public String getFilename() {
        return this.filename;
    }

    private static Stream<TimeRange> steps(TimeRange duration, long flowCount) {
        long maxSamples = 1000L;
        long stepSeconds = 1000L / Math.max(1L, flowCount);
        long stepSize = TimeUnit.SECONDS.toNanos(Math.max(2L, stepSeconds));
        long start = duration.start;
        return Stream.iterate(new TimeRange(start, start + stepSize), range -> range.start <= timeRange.end, current -> new TimeRange(current.start + stepSize, current.end + stepSize));
    }

    public Stream<String> createPartialReport(ReportGeneration reportGeneration, ReportPreferencesInterface preferences) {
        ReportData data = new ReportData(reportGeneration, preferences);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonScenario scenario = new JsonScenario(data);
        TimeRange duration = scenario.totalDuration();
        LinkedList starts = new LinkedList(JsonReportManager.steps(duration, scenario.flowCount()).collect(Collectors.toList()));
        Stream<String> more = Stream.generate(() -> {
            if (starts.isEmpty()) {
                return null;
            }
            TimeRange todo = (TimeRange)starts.pop();
            while (!starts.isEmpty()) {
                TimeRange next = (TimeRange)starts.peek();
                TimeRange larger = new TimeRange(todo.start, next.end);
                JsonScenario smallerScenario = new JsonScenario(data, larger.start, larger.end);
                long size = smallerScenario.approxByteSize();
                long renderedSize = size;
                if ((double)renderedSize > 1.5E7) break;
                todo = larger;
                starts.pop();
            }
            JsonScenario smallerScenario = new JsonScenario(data, todo.start, todo.end);
            String result = gson.toJson((Object)smallerScenario);
            LOGGER.info(String.format("Actual size: %f MByte", (double)result.length() / 1000000.0));
            return result;
        });
        return more.takeWhile(val -> val != null);
    }

    public void createHiddenReport(ReportGeneration reportGeneration, ReportTemplateEntity reportTemplate, ReportPreferencesInterface preferences, IProgressMonitor monitor) {
        ReportData data = new ReportData(reportGeneration, preferences);
        String filename = JsonReportManager.getFileName((ReportPreferencesInterface)preferences, (ReportGeneration)reportGeneration, (ReportOutputFormat)ReportOutputFormat.json);
        File file = new File(filename);
        file.getParentFile().mkdirs();
        try {
            Throwable throwable = null;
            Object var9_12 = null;
            try (FileWriter fileOut = new FileWriter(filename, false);){
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                JsonScenario scenario = new JsonScenario(data);
                gson.toJson((Object)scenario, (Appendable)fileOut);
                this.filename = filename;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException io) {
            LOGGER.log(Level.WARNING, "Can't write away the JSON report", io);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception during JSON report generation.", e);
        }
    }

    public void createReport(ReportGeneration reportGeneration, ReportTemplateEntity reportTemplate, ReportPreferencesInterface preferences, GenerateReportListener listener, IProgressMonitor monitor) {
        ReportData data = new ReportData(reportGeneration, preferences);
        String filename = JsonReportManager.getFileName((ReportPreferencesInterface)preferences, (ReportGeneration)reportGeneration, (ReportOutputFormat)ReportOutputFormat.json);
        File file = new File(filename);
        file.getParentFile().mkdirs();
        try {
            Throwable throwable = null;
            Object var10_13 = null;
            try (FileWriter fileOut = new FileWriter(filename, false);){
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                gson.toJson((Object)new JsonScenario(data), (Appendable)fileOut);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException io) {
            LOGGER.log(Level.WARNING, "Can't write away the JSON report", io);
            return;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception during JSON report generation.", e);
            return;
        }
        listener.onReportExported(reportGeneration, filename, ReportOutputFormat.json);
    }

    public static class PartialResult {
        long totalTime;
        String jsonContent;
    }
}

