/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext.json;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.report.generator.plaintext.json.ISO8601;
import com.excentis.products.byteblower.report.generator.plaintext.json.JsonEvent;
import com.excentis.products.byteblower.report.generator.plaintext.json.JsonFbFlow;
import com.excentis.products.byteblower.report.generator.plaintext.json.JsonHttpFlow;
import com.excentis.products.byteblower.report.generator.plaintext.json.JsonIpv4Port;
import com.excentis.products.byteblower.report.generator.plaintext.json.JsonIpv6Port;
import com.excentis.products.byteblower.report.generator.plaintext.json.JsonPortGroup;
import com.excentis.products.byteblower.report.generator.plaintext.json.JsonRFC2544Flow;
import com.excentis.products.byteblower.report.generator.plaintext.json.JsonServer;
import com.excentis.products.byteblower.report.generator.plaintext.json.SizeEstimation;
import com.excentis.products.byteblower.report.generator.plaintext.json.TimeRange;
import com.excentis.products.byteblower.report.generator.plaintext.json.WirelessEndpointData;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonScenario
implements SizeEstimation {
    private final String documentation = "https://api.byteblower.com/json";
    private String scenarioName;
    private String projectAuthor;
    private String runTitle;
    private String startMoment;
    private String endMoment;
    private String scenarioState;
    private String projectName;
    private String guiVersion;
    private List<JsonServer> servers;
    private List<JsonIpv4Port> ipv4Ports;
    private List<JsonIpv6Port> ipv6Ports;
    private List<JsonPortGroup> portGroups;
    private List<JsonFbFlow> frameBlastingFlows;
    private List<JsonHttpFlow> httpFlows;
    private List<JsonRFC2544Flow> rfc2544Flows;
    private List<JsonEvent> events;
    private List<WirelessEndpointData> wifiStatistics;
    private Map<String, Double> lossConfiguration;

    public JsonScenario() {
    }

    public JsonScenario(ReportData data) {
        this(data, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public JsonScenario(ReportData data, long start, long end) {
        TestDataReference reference = data.getDataReference();
        this.scenarioName = reference.getTestName();
        this.projectAuthor = reference.getProjectAuthor();
        this.runTitle = reference.getTestRunTitle();
        this.startMoment = ISO8601.toString(reference.getStartTime());
        if (reference.getEndTime() != null) {
            this.endMoment = ISO8601.toString(reference.getEndTime());
        }
        this.scenarioState = reference.getStatus().name();
        this.projectName = reference.getProjectName();
        this.guiVersion = reference.getProjectVersion();
        this.servers = JsonServer.create(data);
        this.wifiStatistics = WirelessEndpointData.create(data, start, end);
        this.ipv4Ports = JsonIpv4Port.ports(data);
        this.ipv6Ports = JsonIpv6Port.ports(data);
        this.portGroups = JsonPortGroup.groups(data);
        this.frameBlastingFlows = JsonFbFlow.flows(data, start, end);
        this.httpFlows = JsonHttpFlow.flows(data, start, end);
        this.rfc2544Flows = JsonRFC2544Flow.flows(data);
        this.events = JsonEvent.events(data);
        this.lossConfiguration = new HashMap<String, Double>();
        this.lossConfiguration.put("warningLevel", Double.parseDouble(ByteBlowerPreferences.getWarningLossLevel()));
        this.lossConfiguration.put("errorLevel", Double.parseDouble(ByteBlowerPreferences.getErrorLossLevel()));
    }

    private static long max(long ... vals) {
        long result = Long.MAX_VALUE;
        long[] lArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            long intermediate = lArray[n2];
            result = Math.max(result, intermediate);
            ++n2;
        }
        return result;
    }

    private TimeRange durationFromTcp() {
        TimeRange range = new TimeRange();
        for (JsonHttpFlow flow : this.httpFlows) {
            range = range.merge(flow.getRange());
        }
        return range;
    }

    private TimeRange durationFromFrameBlasting() {
        TimeRange range = new TimeRange();
        for (JsonFbFlow flow : this.frameBlastingFlows) {
            range = range.merge(flow.getRange());
        }
        return range;
    }

    private TimeRange durationFromWiFi() {
        TimeRange range = new TimeRange();
        for (WirelessEndpointData stat : this.wifiStatistics) {
            range = range.merge(stat.getRange());
        }
        return range;
    }

    public TimeRange totalDuration() {
        return this.durationFromWiFi().merge(this.durationFromTcp()).merge(this.durationFromFrameBlasting());
    }

    public int flowCount() {
        return this.wifiStatistics.size() + this.frameBlastingFlows.size() + this.httpFlows.size();
    }

    @Override
    public long approxByteSize() {
        long approxSize = 500L;
        approxSize += 700L * (long)(this.ipv4Ports.size() + this.ipv6Ports.size());
        for (JsonFbFlow fbFlow : this.frameBlastingFlows) {
            approxSize += fbFlow.approxByteSize();
        }
        for (JsonHttpFlow httpFlow : this.httpFlows) {
            approxSize += httpFlow.approxByteSize();
        }
        for (WirelessEndpointData wifi : this.wifiStatistics) {
            approxSize += wifi.approxByteSize();
        }
        return approxSize;
    }
}

