/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext.json;

import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.results.testdata.data.BaseEntityManager;
import com.excentis.products.byteblower.results.testdata.data.entities.Server;
import com.excentis.products.byteblower.results.testdata.data.enums.ServerType;
import java.util.ArrayList;
import java.util.List;

public class JsonServer {
    private String host;
    private String ipAddress;
    private String type;
    private String version;

    public JsonServer(Server dbServer, ReportData data) {
        this.host = dbServer.getName();
        this.ipAddress = dbServer.getUrl() == null ? "" : dbServer.getUrl();
        ServerType serverType = dbServer.getType();
        this.type = serverType == null ? "" : serverType.getCode();
        this.version = dbServer.getVersion() == null ? "" : dbServer.getVersion();
    }

    public static List<JsonServer> create(ReportData data) {
        ArrayList<JsonServer> servers = new ArrayList<JsonServer>();
        BaseEntityManager serverManager = new BaseEntityManager(Server.class, data.testDataController());
        for (Server server : serverManager.getEntities()) {
            servers.add(new JsonServer(server, data));
        }
        servers.sort((first, second) -> {
            int onIp = first.ipAddress.compareTo(second.ipAddress);
            if (onIp == 0) {
                return first.type.compareTo(second.type);
            }
            return onIp;
        });
        return servers;
    }
}

