/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext.json;

import com.excentis.products.byteblower.report.generator.plaintext.json.ISO8601;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotRetransmissionCounters;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotRxCounters;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotTxCounters;

class JsonTCPSnapshot {
    String timestamp;
    transient long iTimestamp;
    long duration;
    long congestionWindowMaximum;
    long congestionWindowMinimum;
    long congestionWindowCurrent;
    long rttMaximum;
    long rttCurrent;
    long rttMinimum;
    long receiverWindowMaximum;
    long receiverWindowCurrent;
    long receiverWindowMinimum;
    long slowRetransmissions;
    long fastRetransmissions;
    long rxHeader;
    long rxPayload;
    long rxTotal;
    long rxSegments;
    long rxSegmentsOutOfOrder;
    long txHeader;
    long txPayload;
    long txTotal;
    long txSegments;
    long localECNMarkings;
    long remoteECNMarkings;

    public JsonTCPSnapshot(TcpSessionSnapshot intervalSnapshot) {
        TcpSessionSnapshotTxCounters txCounters;
        TcpSessionSnapshotRxCounters rxCounters;
        this.timestamp = ISO8601.instantString(intervalSnapshot.getSnapshotTime());
        this.iTimestamp = intervalSnapshot.getSnapshotTime();
        this.duration = intervalSnapshot.getSnapshotDuration();
        this.congestionWindowMaximum = intervalSnapshot.getCongestionWindowMaximum();
        this.congestionWindowCurrent = intervalSnapshot.getCongestionWindowCurrent();
        this.congestionWindowMinimum = intervalSnapshot.getCongestionWindowMinimum();
        this.receiverWindowMaximum = intervalSnapshot.getReceiverWindowMaximum();
        this.receiverWindowCurrent = intervalSnapshot.getReceiverWindowCurrent();
        this.receiverWindowMinimum = intervalSnapshot.getReceiverWindowMinimum();
        this.rttMaximum = intervalSnapshot.getRoundTripTimeMaximum();
        this.rttCurrent = intervalSnapshot.getRoundTripTimeCurrent();
        this.rttMinimum = intervalSnapshot.getRoundTripTimeMinimum();
        this.localECNMarkings = intervalSnapshot.getLocalECNMarkings();
        this.remoteECNMarkings = intervalSnapshot.getRemoteECNMarkings();
        intervalSnapshot.getSlowStartThresholdCurrent();
        TcpSessionSnapshotRetransmissionCounters retransmisisons = intervalSnapshot.getRetransmissions();
        if (retransmisisons != null) {
            this.fastRetransmissions = intervalSnapshot.getRetransmissions().getFastRetransmissions();
            this.slowRetransmissions = intervalSnapshot.getRetransmissions().getSlowRetransmissions();
        }
        if ((rxCounters = intervalSnapshot.getRxCounters()) != null) {
            this.rxHeader = rxCounters.getBytesHeader();
            this.rxPayload = rxCounters.getBytesPayload();
            this.rxTotal = rxCounters.getBytesTotal();
            this.rxSegments = rxCounters.getSegmentCount();
            this.rxSegmentsOutOfOrder = rxCounters.getSegmentsOutofOrder();
        }
        if ((txCounters = intervalSnapshot.getTxCounters()) != null) {
            this.txHeader = txCounters.getBytesHeader();
            this.txPayload = txCounters.getBytesPayload();
            this.txTotal = txCounters.getBytesTotal();
            this.txSegments = txCounters.getSegmentCount();
        }
    }
}

