/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext.json;

import com.excentis.products.byteblower.report.generator.plaintext.json.ISO8601;
import com.excentis.products.byteblower.report.generator.plaintext.json.JsonTCPSnapshot;
import com.excentis.products.byteblower.report.generator.plaintext.json.LazyQuery;
import com.excentis.products.byteblower.report.generator.plaintext.json.TimeRange;
import com.excentis.products.byteblower.results.testdata.data.CumulativeSnapshotManager;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotRetransmissionCounters;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotRxCounters;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotSynReceived;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotSynSent;
import com.excentis.products.byteblower.results.testdata.data.entities.TcpSessionSnapshotTxCounters;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.TcpSessionReader;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collection;

class JsonTcpSessionEnd {
    String portName;
    String caa;
    long congestionWindowMaximum;
    long congestionWindowMinimum;
    long rttMaximum;
    long rttAverage;
    long rttMinimum;
    long receiverWindowMaximum;
    long receiverWindowMinimum;
    Integer configuredWindowScale;
    Integer initialReceiveWindow;
    long slowRetransmissions;
    long fastRetransmissions;
    long rxHeader;
    long rxPayload;
    long rxTotal;
    long rxSegments;
    long rxSegmentsOutOfOrder;
    long txHeader;
    long txPayload;
    long txTotal;
    long txSegments;
    String synTx;
    String synRx;
    Collection<JsonTCPSnapshot> overTimeResults = new ArrayList<JsonTCPSnapshot>();

    public JsonTcpSessionEnd(HttpFlowInstance parentFlow, HttpSession httpSession, TestDataPersistenceController tdc, long start, long end) {
        TcpSessionSnapshotSynSent synTxDatabase;
        this.portName = httpSession.getHttpApplication().getPort().getName();
        TcpSession tcp = httpSession.getTcpSession();
        this.caa = tcp.getCongestionAvoidanceAlgorithm() != null ? tcp.getCongestionAvoidanceAlgorithm().name() : "Unknown";
        this.configuredWindowScale = parentFlow.getFlowTemplate().getRxWindowScaleValue();
        this.initialReceiveWindow = parentFlow.getFlowTemplate().getRxWindowInitialUnscaledSize();
        CumulativeSnapshotManager cumul = new CumulativeSnapshotManager(tdc);
        TcpSessionSnapshot cumulSnapshot = cumul.find(tcp);
        TcpSessionSnapshotSynReceived synRxDatabase = cumul.findSynRx(tcp);
        if (synRxDatabase != null) {
            this.synRx = ISO8601.instantString(synRxDatabase.getTimeLastSynReceived());
        }
        if ((synTxDatabase = cumul.findSynSent(tcp)) != null) {
            this.synTx = ISO8601.instantString(synTxDatabase.getTimeLastSynSent());
        }
        if (cumulSnapshot != null) {
            TcpSessionSnapshotTxCounters txCounters;
            TcpSessionSnapshotRxCounters rxCounters;
            this.congestionWindowMaximum = cumulSnapshot.getCongestionWindowMaximum();
            this.congestionWindowMinimum = cumulSnapshot.getCongestionWindowMinimum();
            this.receiverWindowMaximum = cumulSnapshot.getReceiverWindowMaximum();
            this.receiverWindowMinimum = cumulSnapshot.getReceiverWindowMinimum();
            this.rttMaximum = cumulSnapshot.getRoundTripTimeMaximum();
            this.rttMinimum = cumulSnapshot.getRoundTripTimeMinimum();
            this.rttAverage = cumulSnapshot.getRoundTripTimeCurrent();
            TcpSessionSnapshotRetransmissionCounters retransmisisons = cumulSnapshot.getRetransmissions();
            if (retransmisisons != null) {
                this.fastRetransmissions = cumulSnapshot.getRetransmissions().getFastRetransmissions();
                this.slowRetransmissions = cumulSnapshot.getRetransmissions().getSlowRetransmissions();
            }
            if ((rxCounters = cumulSnapshot.getRxCounters()) != null) {
                this.rxHeader = rxCounters.getBytesHeader();
                this.rxPayload = rxCounters.getBytesPayload();
                this.rxTotal = rxCounters.getBytesTotal();
                this.rxSegments = rxCounters.getSegmentCount();
                this.rxSegmentsOutOfOrder = rxCounters.getSegmentsOutofOrder();
            }
            if ((txCounters = cumulSnapshot.getTxCounters()) != null) {
                this.txHeader = txCounters.getBytesHeader();
                this.txPayload = txCounters.getBytesPayload();
                this.txTotal = txCounters.getBytesTotal();
                this.txSegments = txCounters.getSegmentCount();
            }
            if (!httpSession.isDockedMobile()) {
                EntityManager g = tdc.getEntityManager();
                TcpSessionReader tcpSessionReader = EntityReaderFactory.create((TcpSession)tcp);
                TypedQuery tcpQuery = tcpSessionReader.getSnapshotsQuery(g, start, end);
                this.overTimeResults = new LazyQuery<TcpSessionSnapshot, JsonTCPSnapshot>(tcpQuery, JsonTCPSnapshot::new);
            }
        }
    }

    public TimeRange getRange() {
        TimeRange result = new TimeRange();
        for (JsonTCPSnapshot snap : this.overTimeResults) {
            TimeRange snapTime = new TimeRange(snap.iTimestamp, snap.iTimestamp + snap.duration);
            result = result.merge(snapTime);
        }
        return result;
    }
}

