/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext.json;

import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.report.generator.plaintext.json.FBLatencySnapshot;
import com.excentis.products.byteblower.report.generator.plaintext.json.LatencyDistributionSnapshot;
import com.excentis.products.byteblower.report.generator.plaintext.json.LazyQuery;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatency;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatencyDistribution;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatencySnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

class LatencyTrigger {
    long jitter;
    long packetsValid;
    long packetsInvalid;
    long average = 0L;
    long minimum = Long.MAX_VALUE;
    long maximum = Long.MIN_VALUE;
    Collection<FBLatencySnapshot> overTimeResults = new ArrayList<FBLatencySnapshot>();
    List<LatencyDistributionSnapshot> distribution = new ArrayList<LatencyDistributionSnapshot>();
    public long packetsBelowRange = 0L;
    public long packetsAboveRange = 0L;

    LatencyTrigger(FbLatency trigger, ReportData data) {
        this(trigger, data, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public LatencyTrigger(FbLatency trigger, ReportData data, long start, long end) {
        EntityManager dataSet = data.testDataController().getEntityManager();
        TypedQuery snapshotQuery = EntityReaderFactory.create((FbLatency)trigger).getSnapshotsQuery(dataSet, start, end);
        this.overTimeResults = new LazyQuery<FbLatencySnapshot, FBLatencySnapshot>(snapshotQuery, FBLatencySnapshot::new);
        this.packetsValid = trigger.getPacketCountValid();
        this.packetsInvalid = trigger.getPacketCountInvalid();
        if (this.packetsValid > 0L) {
            this.jitter = trigger.getJitter();
            this.average = trigger.getLatencyAverage();
            this.maximum = trigger.getLatencyMaximum();
            this.minimum = trigger.getLatencyMinimum();
        }
        if (trigger.getDistribution() != null) {
            FbLatencyDistribution fbDist = trigger.getDistribution();
            this.packetsBelowRange = fbDist.getPacketCountBelowMinimum();
            this.packetsAboveRange = fbDist.getPacketCountAboveMaximum();
            for (Map.Entry dBbin : fbDist.getEntries().entrySet()) {
                this.addToLatencyDistribution((Long)dBbin.getKey(), (Long)dBbin.getKey() + fbDist.getBucketWidth(), (Long)dBbin.getValue());
            }
            Collections.sort(this.distribution, new Comparator<LatencyDistributionSnapshot>(){

                @Override
                public int compare(LatencyDistributionSnapshot lhs, LatencyDistributionSnapshot rhs) {
                    return lhs.start > rhs.start ? 1 : (lhs.start < rhs.start ? -1 : 0);
                }
            });
        }
    }

    private void addToLatencyDistribution(long start, long end, long packetCount) {
        LatencyDistributionSnapshot jsonBin = new LatencyDistributionSnapshot(start, end, packetCount);
        this.distribution.add(jsonBin);
    }
}

