/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext.json;

import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.TypedQuery;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.function.Function;

public class LazyQuery<SrcType, ResultType>
extends AbstractCollection<ResultType> {
    private final Function<SrcType, ResultType> convertor;
    private final TypedQuery<SrcType> query;

    public LazyQuery(TypedQuery<SrcType> snapshotQuery, Function<SrcType, ResultType> convertor) {
        this.query = snapshotQuery;
        this.query.setHint("jakarta.persistence.cache.storeMode", (Object)CacheStoreMode.BYPASS);
        this.query.setHint("eclipselink.maintain-cache", (Object)"False");
        this.convertor = convertor;
    }

    @Override
    public Iterator<ResultType> iterator() {
        final Iterator dbResults = this.query.getResultList().iterator();
        return new Iterator<ResultType>(){

            @Override
            public boolean hasNext() {
                return dbResults.hasNext();
            }

            @Override
            public ResultType next() {
                return LazyQuery.this.convertor.apply(dbResults.next());
            }
        };
    }

    @Override
    public int size() {
        return this.query.getResultList().size();
    }
}

