/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext.json;

import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.report.generator.plaintext.json.FBOutOfSequenceSnapshot;
import com.excentis.products.byteblower.report.generator.plaintext.json.LazyQuery;
import com.excentis.products.byteblower.results.testdata.data.entities.FbOutOfSequence;
import com.excentis.products.byteblower.results.testdata.data.entities.FbOutOfSequenceSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collection;

class OutOfSequenceTrigger {
    long packetsValid;
    long packetsInvalid;
    long packetsOutOfSequence;
    Collection<FBOutOfSequenceSnapshot> overTimeResults = new ArrayList<FBOutOfSequenceSnapshot>();

    OutOfSequenceTrigger(FbOutOfSequence trigger, ReportData data) {
        this(trigger, data, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    OutOfSequenceTrigger(FbOutOfSequence trigger, ReportData data, long start, long end) {
        EntityManager dataSet = data.testDataController().getEntityManager();
        TypedQuery snapshotQuery = EntityReaderFactory.create((FbOutOfSequence)trigger).getSnapshotsQuery(dataSet, start, end);
        this.overTimeResults = new LazyQuery<FbOutOfSequenceSnapshot, FBOutOfSequenceSnapshot>(snapshotQuery, FBOutOfSequenceSnapshot::new);
        this.packetsValid = trigger.getPacketCountValid();
        this.packetsInvalid = trigger.getPacketCountInvalid();
        this.packetsOutOfSequence = trigger.getPacketCountOutOfSequence();
    }
}

