/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext.json;

import java.time.Instant;
import java.util.concurrent.TimeUnit;

public class TimeRange {
    public final long start;
    public final long end;

    public TimeRange() {
        this.start = Long.MAX_VALUE;
        this.end = Long.MIN_VALUE;
    }

    public TimeRange(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public long seconds() {
        return Math.max(0L, TimeUnit.NANOSECONDS.toSeconds(this.end - this.start));
    }

    public TimeRange start(long newVal) {
        return new TimeRange(Math.min(newVal, this.start), this.end);
    }

    public TimeRange stop(long newVal) {
        return new TimeRange(this.start, Math.max(newVal, this.end));
    }

    public TimeRange sample(long newVal) {
        return new TimeRange(Math.min(newVal, this.start), Math.max(newVal, this.end));
    }

    public TimeRange merge(TimeRange range) {
        return new TimeRange(Math.min(this.start, range.start), Math.max(this.end, range.end));
    }

    public String toString() {
        return String.format("Range: [%s<%d>, %s<%d>", Instant.ofEpochMilli((long)((double)this.start / 1000000.0)), this.start, Instant.ofEpochMilli((long)((double)this.end / 1000000.0)), this.end);
    }
}

