/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext.json;

import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.report.generator.plaintext.json.FBSnapshot;
import com.excentis.products.byteblower.report.generator.plaintext.json.ISO8601;
import com.excentis.products.byteblower.report.generator.plaintext.json.LazyQuery;
import com.excentis.products.byteblower.report.generator.plaintext.json.SizeEstimation;
import com.excentis.products.byteblower.report.generator.plaintext.json.TimeRange;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTrigger;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTriggerSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.Collection;

class Trigger
implements SizeEstimation {
    long bytes;
    long packets;
    String firstPacketTime;
    String lastPacketTime;
    Collection<FBSnapshot> overTimeResults = new ArrayList<FBSnapshot>();

    Trigger(FbTrigger trigger, ReportData data) {
        this(trigger, data, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public Trigger(FbTrigger trigger, ReportData data, long start, long end) {
        EntityManager dataSet = data.testDataController().getEntityManager();
        TypedQuery snapshotQuery = EntityReaderFactory.create((FbTrigger)trigger).getSnapshotsQuery(dataSet, start, end);
        this.overTimeResults = new LazyQuery<FbTriggerSnapshot, FBSnapshot>(snapshotQuery, FBSnapshot::new);
        this.bytes = trigger.getByteCount();
        this.packets = trigger.getPacketCount();
        if (this.bytes > 0L) {
            this.firstPacketTime = ISO8601.instantString(trigger.getFirstPacketTime());
            this.lastPacketTime = ISO8601.instantString(trigger.getLastPacketTime());
        }
    }

    public TimeRange getRange() {
        TimeRange result = new TimeRange();
        for (FBSnapshot snap : this.overTimeResults) {
            result = result.merge(new TimeRange(snap.itimestamp, snap.itimestamp + snap.duration));
        }
        return result;
    }

    @Override
    public long approxByteSize() {
        return 100L + 500L * (long)this.overTimeResults.size();
    }
}

