/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.report.generator.plaintext.json;

import com.excentis.products.byteblower.report.generator.plaintext.ReportData;
import com.excentis.products.byteblower.report.generator.plaintext.json.ISO8601;
import com.excentis.products.byteblower.report.generator.plaintext.json.SizeEstimation;
import com.excentis.products.byteblower.report.generator.plaintext.json.TimeRange;
import com.excentis.products.byteblower.results.testdata.data.TestDataPersistenceController;
import com.excentis.products.byteblower.results.testdata.data.entities.WiFiSample;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class WirelessEndpointData
implements SizeEstimation {
    protected String networkInterface;
    protected String wirelessEndpoint;
    protected List<Sample> overTimeResults;

    public WirelessEndpointData() {
        this.networkInterface = "unknown";
        this.wirelessEndpoint = "unknown";
        this.overTimeResults = new ArrayList<Sample>();
    }

    private WirelessEndpointData(String interfaceName, String wepName, Collection<WiFiSample> value) {
        this.networkInterface = interfaceName;
        this.wirelessEndpoint = wepName;
        this.overTimeResults = new ArrayList<Sample>();
        for (WiFiSample dbSample : value) {
            Sample nn = new Sample();
            nn.ssid = dbSample.getSsid();
            nn.bssid = dbSample.getBssid();
            nn.rssi = dbSample.getRssi();
            nn.timestamp = ISO8601.instantString(dbSample.getTimestamp());
            nn.iTimestamp = dbSample.getTimestamp();
            this.overTimeResults.add(nn);
        }
    }

    public TimeRange getRange() {
        TimeRange range = new TimeRange();
        for (Sample sample : this.overTimeResults) {
            range = range.sample(sample.iTimestamp);
        }
        return range;
    }

    public static List<WirelessEndpointData> create(ReportData reportData) {
        return WirelessEndpointData.create(reportData, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public static List<WirelessEndpointData> create(ReportData reportData, long start, long end) {
        ArrayList<WirelessEndpointData> result = new ArrayList<WirelessEndpointData>();
        HashMap<String, TreeMap> byDevice = new HashMap<String, TreeMap>();
        for (WiFiSample wiFiSample : WiFiSample.getSamples((TestDataPersistenceController)reportData.testDataController())) {
            boolean inTimeRange;
            boolean bl = inTimeRange = start <= wiFiSample.getTimestamp() && wiFiSample.getTimestamp() < end;
            if (!inTimeRange) continue;
            String key = String.valueOf(wiFiSample.getPortname()) + " -- " + wiFiSample.getNetinterface();
            byDevice.computeIfAbsent(key, k -> new TreeMap()).put(wiFiSample.getTimestamp(), wiFiSample);
        }
        for (Map.Entry entry : byDevice.entrySet()) {
            WiFiSample asample = (WiFiSample)((TreeMap)entry.getValue()).firstEntry().getValue();
            result.add(new WirelessEndpointData(asample.getNetinterface(), asample.getPortname(), ((TreeMap)entry.getValue()).values()));
        }
        return result;
    }

    @Override
    public long approxByteSize() {
        return 500L * (long)this.overTimeResults.size();
    }

    static class Sample {
        protected String timestamp;
        public transient long iTimestamp;
        protected String bssid;
        protected String ssid;
        protected long rssi;

        Sample() {
        }
    }
}

